/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.configurable;

import io.helidon.common.context.ContextAwareExecutorService;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ThreadPool
extends ThreadPoolExecutor {
    private static final Logger LOGGER = Logger.getLogger(ThreadPool.class.getName());
    private final String name;
    private final int queueCapacity;
    private final AtomicInteger peakQueueSize;

    public static Optional<ThreadPool> asThreadPool(ExecutorService executor) {
        if (executor instanceof ThreadPool) {
            return Optional.of((ThreadPool)executor);
        }
        if (executor instanceof ContextAwareExecutorService) {
            return ThreadPool.asThreadPool(((ContextAwareExecutorService)executor).unwrap());
        }
        return Optional.empty();
    }

    ThreadPool(String name, int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, int workQueueCapacity, ThreadFactory threadFactory) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
        this.name = name;
        this.queueCapacity = workQueueCapacity;
        this.peakQueueSize = new AtomicInteger();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(this.toString());
        }
    }

    @Override
    public void execute(Runnable command) {
        super.execute(command);
        int queueSize = this.getQueue().size();
        int currentPeak = this.peakQueueSize.get();
        if (queueSize > currentPeak) {
            this.peakQueueSize.compareAndSet(currentPeak, queueSize);
        }
    }

    public String getName() {
        return this.name;
    }

    public int getQueueCapacity() {
        return this.queueCapacity;
    }

    public int getPeakQueueSize() {
        return this.peakQueueSize.get();
    }

    @Override
    public String toString() {
        return "ThreadPool '" + this.getName() + "' {corePoolSize=" + this.getCorePoolSize() + ", maxPoolSize=" + this.getMaximumPoolSize() + (this.getMaximumPoolSize() > this.getCorePoolSize() ? ", largestPoolSize=" + this.getLargestPoolSize() : "") + ", completedTasks=" + this.getCompletedTaskCount() + ", peakQueueSize=" + this.getPeakQueueSize() + ", queueCapacity=" + this.getQueueCapacity() + '}';
    }
}

