/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.configurable;

import io.helidon.common.configurable.ThreadPool;
import io.helidon.common.context.Contexts;
import io.helidon.config.Config;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.logging.Logger;

public final class ThreadPoolSupplier
implements Supplier<ExecutorService> {
    private static final Logger LOGGER = Logger.getLogger(ThreadPoolSupplier.class.getName());
    private static final ThreadPool.RejectionHandler DEFAULT_REJECTION_POLICY = new ThreadPool.RejectionHandler();
    private static final AtomicInteger DEFAULT_NAME_COUNTER = new AtomicInteger();
    private static final int DEFAULT_CORE_POOL_SIZE = 10;
    private static final int DEFAULT_MAX_POOL_SIZE = 50;
    private static final int DEFAULT_KEEP_ALIVE_MINUTES = 3;
    private static final int DEFAULT_QUEUE_CAPACITY = 10000;
    private static final boolean DEFAULT_IS_DAEMON = true;
    private static final String DEFAULT_THREAD_NAME_PREFIX = "helidon-";
    private static final boolean DEFAULT_PRESTART = true;
    private static final String DEFAULT_POOL_NAME_PREFIX = "helidon-thread-pool-";
    private static final int DEFAULT_GROWTH_RATE = 0;
    private static final int DEFAULT_GROWTH_THRESHOLD = 1000;
    private final int corePoolSize;
    private final int maxPoolSize;
    private final int keepAliveMinutes;
    private final int queueCapacity;
    private final boolean isDaemon;
    private final String threadNamePrefix;
    private final boolean prestart;
    private final String name;
    private final int growthThreshold;
    private final int growthRate;
    private final ThreadPool.RejectionHandler rejectionHandler;
    private volatile ExecutorService instance;

    private ThreadPoolSupplier(Builder builder) {
        this.corePoolSize = builder.corePoolSize;
        this.maxPoolSize = builder.maxPoolSize;
        this.keepAliveMinutes = builder.keepAliveMinutes;
        this.queueCapacity = builder.queueCapacity;
        this.isDaemon = builder.isDaemon;
        this.threadNamePrefix = builder.threadNamePrefix;
        this.prestart = builder.prestart;
        this.name = builder.name == null ? DEFAULT_POOL_NAME_PREFIX + DEFAULT_NAME_COUNTER.incrementAndGet() : builder.name;
        this.growthThreshold = builder.growthThreshold;
        this.growthRate = builder.growthRate;
        this.rejectionHandler = builder.rejectionHandler == null ? DEFAULT_REJECTION_POLICY : builder.rejectionHandler;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ThreadPoolSupplier create(Config config) {
        return ThreadPoolSupplier.builder().config(config).build();
    }

    public static ThreadPoolSupplier create() {
        return ThreadPoolSupplier.builder().build();
    }

    ThreadPool getThreadPool() {
        ThreadPool result = ThreadPool.create(this.name, this.corePoolSize, this.maxPoolSize, this.growthThreshold, this.growthRate, this.keepAliveMinutes, TimeUnit.MINUTES, this.queueCapacity, this.threadNamePrefix, this.isDaemon, this.rejectionHandler);
        if (this.prestart) {
            result.prestartAllCoreThreads();
        }
        return result;
    }

    @Override
    public synchronized ExecutorService get() {
        if (null == this.instance) {
            this.instance = Contexts.wrap((ExecutorService)this.getThreadPool());
        }
        return this.instance;
    }

    public static final class Builder
    implements io.helidon.common.Builder<ThreadPoolSupplier> {
        private int corePoolSize = 10;
        private int maxPoolSize = 50;
        private int keepAliveMinutes = 3;
        private int queueCapacity = 10000;
        private boolean isDaemon = true;
        private String threadNamePrefix = "helidon-";
        private boolean prestart = true;
        private int growthThreshold = 1000;
        private int growthRate = 0;
        private ThreadPool.RejectionHandler rejectionHandler = ThreadPoolSupplier.access$1200();
        private String name;

        private Builder() {
        }

        public ThreadPoolSupplier build() {
            if (this.name == null) {
                this.name = ThreadPoolSupplier.DEFAULT_POOL_NAME_PREFIX + DEFAULT_NAME_COUNTER.incrementAndGet();
            }
            if (this.rejectionHandler == null) {
                this.rejectionHandler = DEFAULT_REJECTION_POLICY;
            }
            return new ThreadPoolSupplier(this);
        }

        public Builder corePoolSize(int corePoolSize) {
            this.corePoolSize = corePoolSize;
            return this;
        }

        public Builder maxPoolSize(int maxPoolSize) {
            this.maxPoolSize = maxPoolSize;
            return this;
        }

        public Builder keepAliveMinutes(int keepAliveMinutes) {
            this.keepAliveMinutes = keepAliveMinutes;
            return this;
        }

        public Builder queueCapacity(int queueCapacity) {
            this.queueCapacity = queueCapacity;
            return this;
        }

        public Builder daemon(boolean daemon) {
            this.isDaemon = daemon;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        Builder growthThreshold(int growthThreshold) {
            this.growthThreshold = growthThreshold;
            return this;
        }

        Builder growthRate(int growthRate) {
            this.growthRate = growthRate;
            return this;
        }

        public Builder rejectionHandler(ThreadPool.RejectionHandler rejectionHandler) {
            this.rejectionHandler = rejectionHandler;
            return this;
        }

        public Builder threadNamePrefix(String threadNamePrefix) {
            this.threadNamePrefix = threadNamePrefix;
            return this;
        }

        public Builder prestart(boolean prestart) {
            this.prestart = prestart;
            return this;
        }

        public Builder config(Config config) {
            config.get("core-pool-size").asInt().ifPresent(this::corePoolSize);
            config.get("max-pool-size").asInt().ifPresent(this::maxPoolSize);
            config.get("keep-alive-minutes").asInt().ifPresent(this::keepAliveMinutes);
            config.get("queue-capacity").asInt().ifPresent(this::queueCapacity);
            config.get("is-daemon").asBoolean().ifPresent(this::daemon);
            config.get("thread-name-prefix").asString().ifPresent(this::threadNamePrefix);
            config.get("should-prestart").asBoolean().ifPresent(this::prestart);
            config.get("growth-threshold").asInt().ifPresent(value -> {
                this.warnExperimental("growth-threshold");
                this.growthThreshold((int)value);
            });
            config.get("growth-rate").asInt().ifPresent(value -> {
                this.warnExperimental("growth-rate");
                this.growthRate((int)value);
            });
            return this;
        }

        private void warnExperimental(String key) {
            LOGGER.warning(String.format("Config key \"executor-service.%s\" is EXPERIMENTAL and subject to change.", key));
        }
    }
}

