/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.crypto;

import io.helidon.common.Base64Value;
import io.helidon.common.crypto.CommonCipher;
import io.helidon.common.crypto.CryptoException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Objects;
import javax.crypto.Cipher;

public class AsymmetricCipher
implements CommonCipher {
    @Deprecated
    public static final String ALGORITHM_RSA_ECB_OAEP_MD5 = "RSA/ECB/OAEPWithMD5AndMGF1Padding";
    public static final String ALGORITHM_RSA_ECB_OAEP_SHA1 = "RSA/ECB/OAEPWithSHA1AndMGF1Padding";
    public static final String ALGORITHM_RSA_ECB_OAEP256 = "RSA/ECB/OAEPWithSHA-256AndMGF1Padding";
    public static final String ALGORITHM_RSA_ECB_OAEP384 = "RSA/ECB/OAEPWithSHA-384AndMGF1Padding";
    public static final String ALGORITHM_RSA_ECB_OAEP512_224 = "RSA/ECB/OAEPWithSHA-512/224AndMGF1Padding";
    public static final String ALGORITHM_RSA_ECB_OAEP512_256 = "RSA/ECB/OAEPWithSHA-512/256AndMGF1Padding";
    public static final String ALGORITHM_RSA_ECB_PKCS1 = "RSA/ECB/PKCS1Padding";
    private final String algorithm;
    private final String provider;
    private final PrivateKey privateKey;
    private final PublicKey publicKey;

    private AsymmetricCipher(Builder builder) {
        this.algorithm = builder.algorithm;
        this.provider = builder.provider;
        this.privateKey = builder.privateKey;
        this.publicKey = builder.publicKey;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Base64Value encrypt(String algorithm, String provider, PublicKey publicKey, Base64Value message) {
        Objects.requireNonNull(algorithm, "Algorithm for encryption cannot be null");
        Objects.requireNonNull(publicKey, "Public key cannot be null");
        Objects.requireNonNull(message, "Message cannot be null");
        try {
            return AsymmetricCipher.performCryptoOperation(1, algorithm, provider, publicKey, message);
        }
        catch (Exception e) {
            throw new CryptoException("Message could not be encrypted", e);
        }
    }

    public static Base64Value decrypt(String algorithm, String provider, PrivateKey privateKey, Base64Value message) {
        Objects.requireNonNull(algorithm, "Algorithm for decryption cannot be null");
        Objects.requireNonNull(privateKey, "Private key cannot be null");
        Objects.requireNonNull(message, "Message cannot be null");
        try {
            return AsymmetricCipher.performCryptoOperation(2, algorithm, provider, privateKey, message);
        }
        catch (Exception e) {
            throw new CryptoException("Message could not be decrypted", e);
        }
    }

    @Override
    public Base64Value encrypt(Base64Value message) {
        if (this.publicKey == null) {
            throw new CryptoException("No public key present. Could not perform encrypt operation");
        }
        return AsymmetricCipher.encrypt(this.algorithm, this.provider, this.publicKey, message);
    }

    @Override
    public Base64Value decrypt(Base64Value encrypted) {
        if (this.privateKey == null) {
            throw new CryptoException("No private key present. Could not perform decryption operation");
        }
        return AsymmetricCipher.decrypt(this.algorithm, this.provider, this.privateKey, encrypted);
    }

    private static Base64Value performCryptoOperation(int mode, String algorithm, String provider, Key key, Base64Value data) throws Exception {
        Cipher cipher = provider == null ? Cipher.getInstance(algorithm) : Cipher.getInstance(algorithm, provider);
        cipher.init(mode, key);
        return Base64Value.create((byte[])cipher.doFinal(data.toBytes()));
    }

    public static final class Builder
    implements io.helidon.common.Builder<AsymmetricCipher> {
        private String algorithm = "RSA/ECB/OAEPWithSHA-256AndMGF1Padding";
        private String provider = null;
        private PrivateKey privateKey;
        private PublicKey publicKey;

        private Builder() {
        }

        public Builder algorithm(String algorithm) {
            this.algorithm = Objects.requireNonNull(algorithm, "Algorithm cannot be null");
            this.provider = null;
            return this;
        }

        public Builder provider(String provider) {
            this.provider = provider;
            return this;
        }

        public Builder privateKey(PrivateKey privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        public Builder publicKey(PublicKey publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        public AsymmetricCipher build() {
            if (this.publicKey == null && this.privateKey == null) {
                throw new CryptoException("At least private or public key has to be set");
            }
            return new AsymmetricCipher(this);
        }
    }
}

