/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class OptionalHelper<T> {
    private Optional<T> optional;

    private OptionalHelper(Optional<T> optional) {
        Objects.requireNonNull(optional);
        this.optional = optional;
    }

    public static <T> OptionalHelper<T> from(Optional<T> optional) {
        return new OptionalHelper<T>(optional);
    }

    public Optional<T> asOptional() {
        return this.optional;
    }

    public OptionalHelper<T> or(Supplier<? extends Optional<T>> supplier) {
        Objects.requireNonNull(supplier);
        if (!this.optional.isPresent()) {
            Optional<T> supplied = supplier.get();
            Objects.requireNonNull(supplied);
            this.optional = supplied;
        }
        return this;
    }

    public void ifPresentOrElse(Consumer<T> action, Runnable emptyAction) {
        if (this.optional.isPresent()) {
            action.accept(this.optional.get());
        } else {
            emptyAction.run();
        }
    }

    public Stream<T> stream() {
        if (!this.optional.isPresent()) {
            return Stream.empty();
        }
        return Stream.of(this.optional.get());
    }
}

