/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.mp;

import io.helidon.common.GenericType;
import io.helidon.config.Config;
import io.helidon.config.ConfigValue;
import io.helidon.config.MetaConfig;
import io.helidon.config.mp.MpConfig;
import io.helidon.config.mp.MpConfigBuilder;
import io.helidon.config.spi.ConfigMapper;
import java.time.Instant;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import org.eclipse.microprofile.config.spi.ConfigSource;

public class MpConfigProviderResolver
extends ConfigProviderResolver {
    private static final Map<ClassLoader, ConfigDelegate> CONFIGS = new IdentityHashMap<ClassLoader, ConfigDelegate>();
    private static final ReadWriteLock RW_LOCK = new ReentrantReadWriteLock();
    private static final List<ConfigDelegate> BUILD_CONFIG = new LinkedList<ConfigDelegate>();

    public org.eclipse.microprofile.config.Config getConfig() {
        return this.getConfig(Thread.currentThread().getContextClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.eclipse.microprofile.config.Config getConfig(ClassLoader classLoader) {
        ClassLoader loader = classLoader == null ? Thread.currentThread().getContextClassLoader() : classLoader;
        Lock lock = RW_LOCK.readLock();
        try {
            lock.lock();
            org.eclipse.microprofile.config.Config config = CONFIGS.get(loader);
            if (null == config) {
                lock.unlock();
                lock = RW_LOCK.writeLock();
                lock.lock();
                org.eclipse.microprofile.config.Config c = this.buildConfig(loader);
                ConfigDelegate configDelegate = this.doRegisterConfig(c, loader);
                return configDelegate;
            }
            org.eclipse.microprofile.config.Config config2 = config;
            return config2;
        }
        finally {
            lock.unlock();
        }
    }

    private org.eclipse.microprofile.config.Config buildConfig(ClassLoader loader) {
        MpConfigBuilder builder = this.getBuilder();
        Optional meta = MetaConfig.metaConfig();
        meta.ifPresent(builder::metaConfig);
        builder.forClassLoader(loader);
        if (meta.isEmpty()) {
            builder.addDefaultSources();
        }
        return builder.addDiscoveredSources().addDiscoveredConverters().build();
    }

    public MpConfigBuilder getBuilder() {
        return new MpConfigBuilder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerConfig(org.eclipse.microprofile.config.Config config, ClassLoader classLoader) {
        ClassLoader usedClassloader = null == classLoader ? Thread.currentThread().getContextClassLoader() : classLoader;
        Lock lock = RW_LOCK.writeLock();
        try {
            lock.lock();
            this.doRegisterConfig(config, usedClassloader);
        }
        finally {
            lock.unlock();
        }
    }

    public static void runtimeStart(org.eclipse.microprofile.config.Config config) {
        if (BUILD_CONFIG.isEmpty()) {
            return;
        }
        BUILD_CONFIG.forEach(it -> it.set(config));
        BUILD_CONFIG.clear();
    }

    public static void buildTimeEnd() {
        Lock lock = RW_LOCK.writeLock();
        try {
            lock.lock();
            CONFIGS.forEach((key, value) -> BUILD_CONFIG.add((ConfigDelegate)value));
            CONFIGS.clear();
        }
        finally {
            lock.unlock();
        }
    }

    private ConfigDelegate doRegisterConfig(org.eclipse.microprofile.config.Config config, ClassLoader classLoader) {
        ConfigDelegate currentConfig = CONFIGS.remove(classLoader);
        if (config instanceof ConfigDelegate) {
            config = ((ConfigDelegate)config).delegate();
        }
        if (null != currentConfig) {
            currentConfig.set(config);
        }
        ConfigDelegate newConfig = new ConfigDelegate(config);
        CONFIGS.put(classLoader, newConfig);
        return newConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseConfig(org.eclipse.microprofile.config.Config config) {
        Lock lock = RW_LOCK.readLock();
        AtomicReference<ClassLoader> cl = new AtomicReference<ClassLoader>();
        try {
            lock.lock();
            for (Map.Entry<ClassLoader, ConfigDelegate> entry : CONFIGS.entrySet()) {
                org.eclipse.microprofile.config.Config configFromRef = entry.getValue().delegate();
                if (config != configFromRef) continue;
                cl.set(entry.getKey());
                break;
            }
        }
        finally {
            lock.unlock();
        }
        if (cl.get() != null) {
            lock = RW_LOCK.writeLock();
            try {
                lock.lock();
                CONFIGS.remove(cl.get());
            }
            finally {
                lock.unlock();
            }
        }
    }

    public static final class ConfigDelegate
    implements Config,
    org.eclipse.microprofile.config.Config {
        private final AtomicReference<org.eclipse.microprofile.config.Config> delegate = new AtomicReference();
        private final AtomicReference<Config> helidonDelegate = new AtomicReference();

        private ConfigDelegate(org.eclipse.microprofile.config.Config delegate) {
            this.set(delegate);
        }

        void set(org.eclipse.microprofile.config.Config delegate) {
            this.delegate.set(delegate);
            if (delegate instanceof Config) {
                this.helidonDelegate.set((Config)delegate);
            } else {
                this.helidonDelegate.set(MpConfig.toHelidonConfig(delegate));
            }
        }

        private Config getCurrent() {
            return this.helidonDelegate.get().context().last();
        }

        public Instant timestamp() {
            return this.getCurrent().timestamp();
        }

        public Config.Key key() {
            return this.getCurrent().key();
        }

        public Config get(Config.Key key) {
            return this.getCurrent().get(key);
        }

        public Config detach() {
            return this.getCurrent().detach();
        }

        public Config.Type type() {
            return this.getCurrent().type();
        }

        public boolean hasValue() {
            return this.getCurrent().hasValue();
        }

        public Stream<Config> traverse(Predicate<Config> predicate) {
            return this.getCurrent().traverse();
        }

        public <T> T convert(Class<T> type, String value) {
            return (T)this.getCurrent().convert(type, value);
        }

        public <T> ConfigValue<T> as(GenericType<T> genericType) {
            return this.getCurrent().as(genericType);
        }

        public <T> ConfigValue<T> as(Class<T> type) {
            return this.getCurrent().as(type);
        }

        public <T> ConfigValue<T> as(Function<Config, T> mapper) {
            return this.getCurrent().as(mapper);
        }

        public <T> ConfigValue<List<T>> asList(Class<T> type) {
            return this.getCurrent().asList(type);
        }

        public <T> ConfigValue<List<T>> asList(Function<Config, T> mapper) {
            return this.getCurrent().asList(mapper);
        }

        public ConfigValue<List<Config>> asNodeList() {
            return this.getCurrent().asNodeList();
        }

        public ConfigValue<Map<String, String>> asMap() {
            return this.getCurrent().asMap();
        }

        public ConfigMapper mapper() {
            return this.getCurrent().mapper();
        }

        public <T> T getValue(String propertyName, Class<T> propertyType) {
            return (T)this.delegate.get().getValue(propertyName, propertyType);
        }

        public <T> Optional<T> getOptionalValue(String propertyName, Class<T> propertyType) {
            return this.delegate.get().getOptionalValue(propertyName, propertyType);
        }

        public Iterable<String> getPropertyNames() {
            return this.delegate.get().getPropertyNames();
        }

        public Iterable<ConfigSource> getConfigSources() {
            return this.delegate.get().getConfigSources();
        }

        public org.eclipse.microprofile.config.Config delegate() {
            return this.delegate.get();
        }
    }
}

