/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.mp;

import io.helidon.config.Config;
import io.helidon.config.ConfigException;
import io.helidon.config.mp.MpEnvironmentVariablesSource;
import io.helidon.config.mp.MpHelidonConfigSource;
import io.helidon.config.mp.MpHelidonSource;
import io.helidon.config.mp.MpMapSource;
import io.helidon.config.mp.MpSystemPropertiesSource;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.microprofile.config.spi.ConfigSource;

public final class MpConfigSources {
    private MpConfigSources() {
    }

    public static ConfigSource create(String name, Map<String, String> theMap) {
        return new MpMapSource(name, theMap);
    }

    public static ConfigSource create(Map<String, String> theMap) {
        return MpConfigSources.create("Map", theMap);
    }

    public static ConfigSource create(Path path) {
        return MpConfigSources.create(path.toString(), path);
    }

    public static ConfigSource create(URL url) {
        ConfigSource configSource;
        block8: {
            String name = url.toString();
            URLConnection urlConnection = url.openConnection();
            InputStream inputStream = urlConnection.getInputStream();
            try {
                Properties properties = new Properties();
                properties.load(inputStream);
                configSource = MpConfigSources.create(name, properties);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new ConfigException("Failed to load ", (Throwable)e);
                }
            }
            inputStream.close();
        }
        return configSource;
    }

    public static ConfigSource create(String name, Path path) {
        Properties props = new Properties();
        try (InputStream in = Files.newInputStream(path, new OpenOption[0]);){
            props.load(in);
        }
        catch (IOException e) {
            throw new ConfigException("Failed to read properties from " + path.toAbsolutePath());
        }
        return MpConfigSources.create(name, props);
    }

    public static ConfigSource create(Properties properties) {
        return MpConfigSources.create("Properties", properties);
    }

    public static ConfigSource create(String name, Properties properties) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String key : properties.stringPropertyNames()) {
            result.put(key, properties.getProperty(key));
        }
        return new MpMapSource(name, result);
    }

    public static ConfigSource environmentVariables() {
        return new MpEnvironmentVariablesSource();
    }

    public static ConfigSource systemProperties() {
        return new MpSystemPropertiesSource();
    }

    public static List<ConfigSource> classPath(String resource) {
        return MpConfigSources.classPath(Thread.currentThread().getContextClassLoader(), resource);
    }

    public static List<ConfigSource> classPath(ClassLoader classLoader, String resource) {
        LinkedList<ConfigSource> sources = new LinkedList<ConfigSource>();
        try {
            classLoader.getResources(resource).asIterator().forEachRemaining(it -> sources.add(MpConfigSources.create(it)));
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to read \"" + resource + "\" from classpath");
        }
        return sources;
    }

    public static ConfigSource create(io.helidon.config.spi.ConfigSource helidonConfigSource) {
        return MpHelidonSource.create(helidonConfigSource);
    }

    public static ConfigSource create(Config config) {
        return new MpHelidonConfigSource(config);
    }
}

