/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.mp;

import io.helidon.common.serviceloader.HelidonServiceLoader;
import io.helidon.config.ConfigException;
import io.helidon.config.ConfigHelper;
import io.helidon.config.mp.MpConfigSources;
import io.helidon.config.spi.ConfigContent;
import io.helidon.config.spi.ConfigNode;
import io.helidon.config.spi.ConfigParser;
import io.helidon.config.spi.LazyConfigSource;
import io.helidon.config.spi.NodeConfigSource;
import io.helidon.config.spi.ParsableSource;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.microprofile.config.spi.ConfigSource;

final class MpHelidonSource {
    private MpHelidonSource() {
    }

    static ConfigSource create(io.helidon.config.spi.ConfigSource source) {
        source.init(it -> {
            throw new UnsupportedOperationException("Source runtimes are not available in MicroProfile Config implementation");
        });
        if (!source.exists() && !source.optional()) {
            throw new ConfigException("Config source " + source + " is mandatory, yet it does not exist.");
        }
        if (source instanceof NodeConfigSource) {
            Optional load = ((NodeConfigSource)source).load();
            return MpConfigSources.create(source.description(), load.map(ConfigContent.NodeContent::data).map(ConfigHelper::flattenNodes).orElseGet(Map::of));
        }
        if (source instanceof ParsableSource) {
            return HelidonParsableSource.create((ParsableSource)source);
        }
        if (source instanceof LazyConfigSource) {
            return new HelidonLazySource(source, (LazyConfigSource)source);
        }
        throw new IllegalArgumentException("Helidon config source must be one of: node source, parsable source, or lazy source. Provided is neither: " + source.getClass().getName());
    }

    private static class HelidonLazySource
    implements ConfigSource {
        private final Map<String, String> loadedProperties = new ConcurrentHashMap<String, String>();
        private final LazyConfigSource lazy;
        private final io.helidon.config.spi.ConfigSource source;

        private HelidonLazySource(io.helidon.config.spi.ConfigSource source, LazyConfigSource lazy) {
            this.lazy = lazy;
            this.source = source;
        }

        public Set<String> getPropertyNames() {
            return Collections.unmodifiableSet(this.loadedProperties.keySet());
        }

        public Map<String, String> getProperties() {
            return Collections.unmodifiableMap(this.loadedProperties);
        }

        public String getValue(String propertyName) {
            String value = this.lazy.node(propertyName).flatMap(ConfigNode::value).orElse(null);
            if (null == value) {
                this.loadedProperties.remove(propertyName);
            } else {
                this.loadedProperties.put(propertyName, value);
            }
            return value;
        }

        public String getName() {
            return this.source.description();
        }
    }

    private static class HelidonParsableSource {
        private HelidonParsableSource() {
        }

        public static ConfigSource create(ParsableSource source) {
            Optional load = source.load();
            if (load.isEmpty()) {
                return MpConfigSources.create(source.description(), Map.of());
            }
            ConfigParser.Content content = (ConfigParser.Content)load.get();
            String mediaType = (String)content.mediaType().or(() -> ((ParsableSource)source).mediaType()).orElseThrow(() -> new ConfigException("Source " + source + " does not provide media type, cannot use it."));
            ConfigParser parser = (ConfigParser)source.parser().or(() -> HelidonParsableSource.findParser(mediaType)).orElseThrow(() -> new ConfigException("Could not locate config parser for media type: \"" + mediaType + "\""));
            return MpConfigSources.create(source.description(), ConfigHelper.flattenNodes((ConfigNode.ObjectNode)parser.parse(content)));
        }

        private static Optional<ConfigParser> findParser(String mediaType) {
            return HelidonServiceLoader.create(ServiceLoader.load(ConfigParser.class)).asList().stream().filter(it -> it.supportedMediaTypes().contains(mediaType)).findFirst();
        }
    }
}

