/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.faulttolerance;

import io.helidon.common.LazyValue;
import io.helidon.faulttolerance.BulkheadImpl;
import io.helidon.faulttolerance.FaultTolerance;
import io.helidon.faulttolerance.FtHandler;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;

public interface Bulkhead
extends FtHandler {
    public static Builder builder() {
        return new Builder();
    }

    public Stats stats();

    public static interface Stats {
        public long concurrentExecutions();

        public long callsAccepted();

        public long callsRejected();

        public long waitingQueueSize();
    }

    public static class Builder
    implements io.helidon.common.Builder<Bulkhead> {
        private static final int DEFAULT_LIMIT = 10;
        private static final int DEFAULT_QUEUE_LENGTH = 10;
        private LazyValue<? extends ExecutorService> executor = FaultTolerance.executor();
        private int limit = 10;
        private int queueLength = 10;
        private String name = "Bulkhead-" + System.identityHashCode(this);

        private Builder() {
        }

        public Bulkhead build() {
            return new BulkheadImpl(this);
        }

        public Builder executor(Supplier<? extends ExecutorService> executor) {
            this.executor = LazyValue.create(Objects.requireNonNull(executor));
            return this;
        }

        public Builder limit(int limit) {
            this.limit = limit;
            return this;
        }

        public Builder queueLength(int queueLength) {
            this.queueLength = queueLength;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        int limit() {
            return this.limit;
        }

        int queueLength() {
            return this.queueLength;
        }

        LazyValue<? extends ExecutorService> executor() {
            return this.executor;
        }

        String name() {
            return this.name;
        }
    }
}

