/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.media.common;

import io.helidon.common.http.MediaType;
import io.helidon.common.http.Parameters;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class ContentTypeCharset {
    public static Charset determineCharset(Parameters headers) {
        return ContentTypeCharset.determineCharset(headers, StandardCharsets.UTF_8);
    }

    public static Charset determineCharset(Parameters headers, Charset defaultCharset) {
        return headers.first("Content-Type").map(MediaType::parse).flatMap(MediaType::charset).map(sch -> {
            try {
                return Charset.forName(sch);
            }
            catch (Exception e) {
                return null;
            }
        }).orElse(defaultCharset);
    }

    private ContentTypeCharset() {
    }
}

