/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.media.jsonp;

import io.helidon.common.GenericType;
import io.helidon.common.http.DataChunk;
import io.helidon.common.http.MediaType;
import io.helidon.common.mapper.Mapper;
import io.helidon.common.reactive.Single;
import io.helidon.media.common.CharBuffer;
import io.helidon.media.common.MessageBodyOperator;
import io.helidon.media.common.MessageBodyWriter;
import io.helidon.media.common.MessageBodyWriterContext;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.concurrent.Flow;
import java.util.function.Function;
import javax.json.JsonStructure;
import javax.json.JsonWriter;
import javax.json.JsonWriterFactory;

class JsonpBodyWriter
implements MessageBodyWriter<JsonStructure> {
    private final JsonWriterFactory jsonWriterFactory;

    JsonpBodyWriter(JsonWriterFactory jsonWriterFactory) {
        this.jsonWriterFactory = jsonWriterFactory;
    }

    public MessageBodyOperator.PredicateResult accept(GenericType<?> type, MessageBodyWriterContext context) {
        return MessageBodyOperator.PredicateResult.supports(JsonStructure.class, type);
    }

    public Flow.Publisher<DataChunk> write(Single<? extends JsonStructure> content, GenericType<? extends JsonStructure> type, MessageBodyWriterContext context) {
        MediaType contentType = context.findAccepted(MediaType.JSON_PREDICATE, MediaType.APPLICATION_JSON);
        context.contentType(contentType);
        return content.map((Function)((Object)new JsonStructureToChunks(this.jsonWriterFactory, context.charset())));
    }

    static final class JsonStructureToChunks
    implements Mapper<JsonStructure, DataChunk> {
        private final JsonWriterFactory factory;
        private final Charset charset;
        private boolean flush = false;

        JsonStructureToChunks(JsonWriterFactory factory, Charset charset) {
            this.factory = factory;
            this.charset = charset;
        }

        JsonStructureToChunks(boolean flush, JsonWriterFactory factory, Charset charset) {
            this.factory = factory;
            this.charset = charset;
            this.flush = flush;
        }

        public DataChunk map(JsonStructure item) {
            CharBuffer buffer = new CharBuffer();
            try (JsonWriter writer = this.factory.createWriter((Writer)buffer);){
                writer.write(item);
                DataChunk dataChunk = DataChunk.create((boolean)this.flush, (ByteBuffer[])new ByteBuffer[]{buffer.encode(this.charset)});
                return dataChunk;
            }
        }
    }
}

