/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.media.jsonp;

import io.helidon.common.GenericType;
import io.helidon.common.http.DataChunk;
import io.helidon.common.http.MediaType;
import io.helidon.common.reactive.Multi;
import io.helidon.common.reactive.Single;
import io.helidon.media.common.MessageBodyOperator;
import io.helidon.media.common.MessageBodyStreamWriter;
import io.helidon.media.common.MessageBodyWriterContext;
import io.helidon.media.jsonp.JsonpBodyWriter;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import javax.json.JsonStructure;
import javax.json.JsonWriterFactory;

class JsonpNdBodyStreamWriter
implements MessageBodyStreamWriter<JsonStructure> {
    private static final byte[] NL = "\n".getBytes(StandardCharsets.UTF_8);
    private final JsonWriterFactory jsonWriterFactory;

    JsonpNdBodyStreamWriter(JsonWriterFactory jsonWriterFactory) {
        this.jsonWriterFactory = Objects.requireNonNull(jsonWriterFactory);
    }

    public MessageBodyOperator.PredicateResult accept(GenericType<?> type, MessageBodyWriterContext context) {
        if (!JsonStructure.class.isAssignableFrom(type.rawType())) {
            return MessageBodyOperator.PredicateResult.NOT_SUPPORTED;
        }
        return context.contentType().or(() -> this.findMediaType(context)).filter(mediaType -> mediaType.equals((Object)MediaType.APPLICATION_X_NDJSON)).map(it -> MessageBodyOperator.PredicateResult.COMPATIBLE).orElse(MessageBodyOperator.PredicateResult.NOT_SUPPORTED);
    }

    public Multi<DataChunk> write(Flow.Publisher<? extends JsonStructure> publisher, GenericType<? extends JsonStructure> type, MessageBodyWriterContext context) {
        MediaType contentType = context.contentType().or(() -> this.findMediaType(context)).orElse(MediaType.APPLICATION_X_NDJSON);
        context.contentType(contentType);
        JsonpBodyWriter.JsonStructureToChunks jsonToChunks = new JsonpBodyWriter.JsonStructureToChunks(true, this.jsonWriterFactory, context.charset());
        AtomicBoolean first = new AtomicBoolean(true);
        return Multi.create(publisher).map((Function)((Object)jsonToChunks)).flatMap(dataChunk -> {
            if (first.getAndSet(false)) {
                return Single.just((Object)dataChunk);
            }
            return Multi.just((Object[])new DataChunk[]{DataChunk.create((byte[])NL), dataChunk});
        });
    }

    private Optional<MediaType> findMediaType(MessageBodyWriterContext context) {
        try {
            return Optional.of(context.findAccepted(MediaType.APPLICATION_X_NDJSON));
        }
        catch (IllegalStateException ignore) {
            return Optional.empty();
        }
    }
}

