/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.media.jsonp;

import io.helidon.common.LazyValue;
import io.helidon.media.common.MediaSupport;
import io.helidon.media.common.MessageBodyReader;
import io.helidon.media.common.MessageBodyStreamWriter;
import io.helidon.media.common.MessageBodyWriter;
import io.helidon.media.jsonp.JsonpBodyReader;
import io.helidon.media.jsonp.JsonpBodyStreamWriter;
import io.helidon.media.jsonp.JsonpBodyWriter;
import io.helidon.media.jsonp.JsonpEsBodyStreamWriter;
import io.helidon.media.jsonp.JsonpNdBodyStreamWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonReaderFactory;
import javax.json.JsonStructure;
import javax.json.JsonWriterFactory;

public final class JsonpSupport
implements MediaSupport {
    private static final LazyValue<JsonpSupport> DEFAULT = LazyValue.create(() -> new JsonpSupport(Builder.readerFactory(null), Builder.writerFactory(null)));
    private final JsonpBodyReader reader;
    private final JsonpBodyWriter writer;
    private final JsonpBodyStreamWriter streamWriter;
    private final JsonpEsBodyStreamWriter esStreamWriter;
    private final JsonpNdBodyStreamWriter ndStreamWriter;

    private JsonpSupport(JsonReaderFactory readerFactory, JsonWriterFactory writerFactory) {
        this.reader = new JsonpBodyReader(readerFactory);
        this.writer = new JsonpBodyWriter(writerFactory);
        this.streamWriter = new JsonpBodyStreamWriter(writerFactory);
        this.esStreamWriter = new JsonpEsBodyStreamWriter(writerFactory);
        this.ndStreamWriter = new JsonpNdBodyStreamWriter(writerFactory);
    }

    public static JsonpSupport create() {
        return (JsonpSupport)DEFAULT.get();
    }

    public static JsonpSupport create(Map<String, ?> jsonPConfig) {
        return JsonpSupport.builder().jsonProcessingConfig(jsonPConfig).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static MessageBodyReader<JsonStructure> reader() {
        return ((JsonpSupport)JsonpSupport.DEFAULT.get()).reader;
    }

    public static MessageBodyReader<JsonStructure> reader(JsonReaderFactory readerFactory) {
        return new JsonpBodyReader(readerFactory);
    }

    public static MessageBodyWriter<JsonStructure> writer() {
        return ((JsonpSupport)JsonpSupport.DEFAULT.get()).writer;
    }

    public static MessageBodyWriter<JsonStructure> writer(JsonWriterFactory writerFactory) {
        return new JsonpBodyWriter(writerFactory);
    }

    public static MessageBodyStreamWriter<JsonStructure> streamWriter() {
        return ((JsonpSupport)JsonpSupport.DEFAULT.get()).streamWriter;
    }

    public static MessageBodyStreamWriter<JsonStructure> streamWriter(JsonWriterFactory writerFactory) {
        return new JsonpBodyStreamWriter(writerFactory);
    }

    public static MessageBodyStreamWriter<JsonStructure> eventStreamWriter() {
        return ((JsonpSupport)JsonpSupport.DEFAULT.get()).esStreamWriter;
    }

    public static MessageBodyStreamWriter<JsonStructure> eventStreamWriter(JsonWriterFactory writerFactory) {
        return new JsonpEsBodyStreamWriter(writerFactory);
    }

    public static MessageBodyStreamWriter<JsonStructure> ndJsonStreamWriter() {
        return ((JsonpSupport)JsonpSupport.DEFAULT.get()).ndStreamWriter;
    }

    public static MessageBodyStreamWriter<JsonStructure> ndJsonStreamWriter(JsonWriterFactory writerFactory) {
        return new JsonpNdBodyStreamWriter(writerFactory);
    }

    public MessageBodyReader<JsonStructure> readerInstance() {
        return this.reader;
    }

    public MessageBodyWriter<JsonStructure> writerInstance() {
        return this.writer;
    }

    public MessageBodyStreamWriter<JsonStructure> streamWriterInstance() {
        return this.streamWriter;
    }

    public MessageBodyStreamWriter<JsonStructure> eventStreamWriterInstance() {
        return this.esStreamWriter;
    }

    public MessageBodyStreamWriter<JsonStructure> ndJsonStreamWriterInstance() {
        return this.ndStreamWriter;
    }

    public Collection<MessageBodyReader<?>> readers() {
        return List.of(this.reader);
    }

    public Collection<MessageBodyWriter<?>> writers() {
        return List.of(this.writer);
    }

    public Collection<MessageBodyStreamWriter<?>> streamWriters() {
        return List.of(this.streamWriter, this.ndStreamWriter, this.esStreamWriter);
    }

    public static class Builder
    implements io.helidon.common.Builder<JsonpSupport> {
        private JsonWriterFactory jsonWriterFactory;
        private JsonReaderFactory jsonReaderFactory;
        private Map<String, ?> jsonPConfig;

        public JsonpSupport build() {
            if (null == this.jsonReaderFactory && null == this.jsonWriterFactory && null == this.jsonPConfig) {
                return (JsonpSupport)DEFAULT.get();
            }
            if (null == this.jsonPConfig) {
                this.jsonPConfig = new HashMap();
            }
            if (null == this.jsonWriterFactory) {
                this.jsonWriterFactory = Builder.writerFactory(this.jsonPConfig);
            }
            if (null == this.jsonReaderFactory) {
                this.jsonReaderFactory = Builder.readerFactory(this.jsonPConfig);
            }
            return new JsonpSupport(this.jsonReaderFactory, this.jsonWriterFactory);
        }

        private static JsonReaderFactory readerFactory(Map<String, ?> jsonPConfig) {
            return Json.createReaderFactory(jsonPConfig);
        }

        private static JsonWriterFactory writerFactory(Map<String, ?> jsonPConfig) {
            return Json.createWriterFactory(jsonPConfig);
        }

        public Builder jsonProcessingConfig(Map<String, ?> config) {
            this.jsonPConfig = config;
            this.jsonWriterFactory = null;
            this.jsonReaderFactory = null;
            return this;
        }

        public Builder jsonWriterFactory(JsonWriterFactory factory) {
            this.jsonWriterFactory = factory;
            return this;
        }

        public Builder jsonReaderFactory(JsonReaderFactory factory) {
            this.jsonReaderFactory = factory;
            return this;
        }
    }
}

