/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.config;

import io.helidon.microprofile.config.MpcSourceSystemProperties;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.microprofile.config.spi.ConfigSource;

final class MpcSourceUrl
implements ConfigSource {
    private final Map<String, String> props;
    private final String source;

    private MpcSourceUrl(Properties props, String source) {
        this.props = MpcSourceSystemProperties.toMap(props);
        this.source = source;
    }

    public static ConfigSource create(URL url) throws IOException {
        try (InputStream inputStream = url.openStream();){
            Properties props = new Properties();
            props.load(inputStream);
            MpcSourceUrl mpcSourceUrl = new MpcSourceUrl(props, url.toString());
            return mpcSourceUrl;
        }
    }

    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.props);
    }

    public String getValue(String propertyName) {
        return this.props.get(propertyName);
    }

    public String getName() {
        return "helidon:url:" + this.source;
    }

    public Set<String> getPropertyNames() {
        return Collections.unmodifiableSet(this.props.keySet());
    }
}

