/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.config;

import io.helidon.config.ConfigException;
import io.helidon.microprofile.config.FieldSetter;
import io.helidon.microprofile.config.FieldTypes;
import jakarta.enterprise.inject.spi.DeploymentException;
import jakarta.enterprise.inject.spi.InjectionPoint;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.inject.ConfigProperties;
import org.eclipse.microprofile.config.inject.ConfigProperty;

final class ConfigBeanDescriptor {
    private final Class<?> type;
    private final String prefix;
    private final Supplier<Object> instanceCreator;
    private final List<FieldSetter> fieldSetters;

    private ConfigBeanDescriptor(Class<?> type, String prefix, Supplier<Object> instanceCreator, List<FieldSetter> fieldSetters) {
        this.type = type;
        this.prefix = prefix;
        this.instanceCreator = instanceCreator;
        this.fieldSetters = fieldSetters;
    }

    static ConfigBeanDescriptor create(Class<?> type, ConfigProperties configProperties) {
        Supplier<Object> instanceCreator;
        if (type.isInterface()) {
            throw new DeploymentException("Only concrete classes can be annotated with ConfigProperties, got " + type.getName());
        }
        try {
            Constructor<?> defaultConstructor = type.getConstructor(new Class[0]);
            instanceCreator = () -> {
                try {
                    return defaultConstructor.newInstance(new Object[0]);
                }
                catch (Exception e) {
                    throw new ConfigException("Failed to instantiate ConfigProperties type " + type.getName(), (Throwable)e);
                }
            };
        }
        catch (NoSuchMethodException e) {
            throw new DeploymentException("Failed to find default constructor on config properties class " + type.getName());
        }
        LinkedList<FieldSetter> fieldSetters = new LinkedList<FieldSetter>();
        for (Field field : type.getDeclaredFields()) {
            String defaultValue;
            String configKey;
            ConfigProperty configProperty = field.getAnnotation(ConfigProperty.class);
            if (configProperty == null) {
                configKey = field.getName();
                defaultValue = null;
            } else {
                configKey = configProperty.name();
                defaultValue = configProperty.defaultValue();
                if ("org.eclipse.microprofile.config.configproperty.unconfigureddvalue".equals(defaultValue) || defaultValue.isEmpty()) {
                    defaultValue = null;
                }
            }
            fieldSetters.add(new FieldSetter(field, configKey, defaultValue));
        }
        String prefix = ConfigBeanDescriptor.findPrefix(configProperties.prefix(), null);
        ConfigBeanDescriptor descriptor = new ConfigBeanDescriptor(type, prefix, instanceCreator, fieldSetters);
        descriptor.validate(ConfigProvider.getConfig(), prefix);
        return descriptor;
    }

    void validate(Config config, String prefix) {
        this.fieldSetters.forEach(it -> it.validate(this.instanceCreator, config, prefix));
    }

    Object produce(InjectionPoint injectionPoint, Config config) {
        Set qualifiers = injectionPoint.getQualifiers();
        ConfigProperties annotation = null;
        for (Annotation qualifier : qualifiers) {
            if (!qualifier.annotationType().equals(ConfigProperties.class)) continue;
            annotation = (ConfigProperties)qualifier;
            break;
        }
        if (annotation == null) {
            return this.produce(config, this.prefix);
        }
        Type type = injectionPoint.getType();
        FieldTypes fieldTypes = FieldTypes.create(type);
        Object value = this.produce(config, ConfigBeanDescriptor.findPrefix(annotation.prefix(), this.prefix));
        if (fieldTypes.field0().rawType().equals(Optional.class)) {
            return Optional.of(value);
        }
        return value;
    }

    Object produce(Config config, String prefix) {
        Object instance = this.instanceCreator.get();
        for (FieldSetter fieldSetter : this.fieldSetters) {
            fieldSetter.set(config, prefix, instance);
        }
        return instance;
    }

    Type type() {
        return this.type;
    }

    private static String findPrefix(String explicitPrefix, String defaultPrefix) {
        if ("org.eclipse.microprofile.config.inject.configproperties.unconfiguredprefix".equals(explicitPrefix)) {
            return defaultPrefix;
        }
        if ("".equals(explicitPrefix)) {
            return null;
        }
        return explicitPrefix;
    }
}

