/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security;

import io.helidon.security.AuthenticationResponse;
import io.helidon.security.CompositeProviderFlag;
import io.helidon.security.CompositeProviderSelectionPolicy;
import io.helidon.security.ProviderRequest;
import io.helidon.security.SecurityResponse;
import io.helidon.security.Subject;
import io.helidon.security.spi.AuthenticationProvider;
import io.helidon.security.spi.ProviderConfig;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

final class CompositeAuthenticationProvider
implements AuthenticationProvider {
    private static final AuthenticationResponse ABSTAIN_RESPONSE = AuthenticationResponse.abstain();
    private final List<Atn> providers = new LinkedList<Atn>();

    CompositeAuthenticationProvider(List<Atn> parts) {
        this.providers.addAll(parts);
    }

    @Override
    public Collection<Class<? extends Annotation>> supportedAnnotations() {
        HashSet<Class<? extends Annotation>> result = new HashSet<Class<? extends Annotation>>();
        this.providers.forEach(atnConfig -> result.addAll(atnConfig.provider.supportedAnnotations()));
        return result;
    }

    @Override
    public Collection<String> supportedConfigKeys() {
        HashSet<String> configKeys = new HashSet<String>();
        this.providers.forEach(atnConfig -> configKeys.addAll(atnConfig.provider.supportedConfigKeys()));
        return configKeys;
    }

    @Override
    public Collection<Class<? extends ProviderConfig>> supportedCustomObjects() {
        HashSet<Class<? extends ProviderConfig>> result = new HashSet<Class<? extends ProviderConfig>>();
        this.providers.forEach(atnConfig -> result.addAll(atnConfig.provider.supportedCustomObjects()));
        return result;
    }

    @Override
    public Collection<String> supportedAttributes() {
        HashSet<String> result = new HashSet<String>();
        this.providers.forEach(atnConfig -> result.addAll(atnConfig.provider.supportedAttributes()));
        return result;
    }

    @Override
    public CompletionStage<AuthenticationResponse> authenticate(ProviderRequest providerRequest) {
        CompletionStage<AtnResponse> result = CompletableFuture.completedFuture(new AtnResponse(ABSTAIN_RESPONSE));
        for (Atn providerConfig : this.providers) {
            result = result.thenCompose(theResponse -> this.invokeProvider((AtnResponse)theResponse, providerConfig, providerRequest));
        }
        return result.thenApply(atnResponse -> {
            List<AuthenticationResponse> successes = atnResponse.successResponses;
            if (successes.isEmpty()) {
                return ABSTAIN_RESPONSE;
            }
            AuthenticationResponse.Builder responseBuilder = (AuthenticationResponse.Builder)AuthenticationResponse.builder().status(SecurityResponse.SecurityStatus.SUCCESS);
            this.combineSubjects(successes, responseBuilder);
            return responseBuilder.build();
        }).exceptionally(throwable -> {
            Throwable cause = throwable.getCause();
            if (null == cause) {
                cause = throwable;
            }
            if (cause instanceof AsyncAtnException) {
                return ((AsyncAtnException)cause).response;
            }
            return AuthenticationResponse.failed("Failed processing: " + throwable.getMessage(), throwable);
        });
    }

    private CompletionStage<AtnResponse> invokeProvider(AtnResponse previous, Atn nextProviderConfig, ProviderRequest providerRequest) {
        List<AuthenticationResponse> successes = previous.successResponses;
        CompositeProviderFlag flag = nextProviderConfig.config.flag();
        return nextProviderConfig.provider.authenticate(providerRequest).thenApply(atnResponse -> {
            this.checkAtnResponseStatus(flag, (AuthenticationResponse)atnResponse, atnResponse.status());
            if (atnResponse.status() == SecurityResponse.SecurityStatus.SUCCESS) {
                successes.add((AuthenticationResponse)atnResponse);
            }
            if (flag == CompositeProviderFlag.SUFFICIENT && atnResponse.status() == SecurityResponse.SecurityStatus.SUCCESS) {
                AuthenticationResponse.Builder responseBuilder = AuthenticationResponse.builder();
                this.combineSubjects(successes, responseBuilder);
                AuthenticationResponse newResponse = ((AuthenticationResponse.Builder)responseBuilder.status(SecurityResponse.SecurityStatus.SUCCESS)).build();
                throw new AsyncAtnException(newResponse);
            }
            if (atnResponse.status() == SecurityResponse.SecurityStatus.ABSTAIN) {
                return new AtnResponse(previous.response, successes);
            }
            return new AtnResponse((AuthenticationResponse)atnResponse, successes);
        });
    }

    private void combineSubjects(List<AuthenticationResponse> successes, AuthenticationResponse.Builder responseBuilder) {
        Subject userSubject = null;
        Subject serviceSubject = null;
        for (AuthenticationResponse success : successes) {
            Subject newSubject;
            Optional<Subject> maybeUser = success.user();
            Optional<Subject> maybeService = success.service();
            if (maybeUser.isPresent()) {
                newSubject = maybeUser.get();
                userSubject = null == userSubject ? newSubject : newSubject.combine(userSubject);
            }
            if (!maybeService.isPresent()) continue;
            newSubject = maybeService.get();
            if (null == serviceSubject) {
                serviceSubject = newSubject;
                continue;
            }
            serviceSubject = newSubject.combine(serviceSubject);
        }
        if (null != userSubject) {
            responseBuilder.user(userSubject);
        }
        if (null != serviceSubject) {
            responseBuilder.service(serviceSubject);
        }
    }

    private void checkAtnResponseStatus(CompositeProviderFlag flag, AuthenticationResponse response, SecurityResponse.SecurityStatus status) {
        if (!flag.isValid(status)) {
            switch (status) {
                case SUCCESS: 
                case SUCCESS_FINISH: 
                case ABSTAIN: {
                    AuthenticationResponse.Builder builder = AuthenticationResponse.builder();
                    builder.status(SecurityResponse.SecurityStatus.FAILURE);
                    builder.description("Composite flag forbids this response: " + response.status());
                    response.description().map(builder::description);
                    response.throwable().map(builder::throwable);
                    throw new AsyncAtnException(builder.build());
                }
            }
            throw new AsyncAtnException(response);
        }
    }

    static class Atn {
        private final CompositeProviderSelectionPolicy.FlaggedProvider config;
        private final AuthenticationProvider provider;

        Atn(CompositeProviderSelectionPolicy.FlaggedProvider config, AuthenticationProvider provider) {
            this.config = config;
            this.provider = provider;
        }
    }

    private static final class AsyncAtnException
    extends RuntimeException {
        private final AuthenticationResponse response;

        private AsyncAtnException(AuthenticationResponse response) {
            this.response = response;
        }
    }

    private static final class AtnResponse {
        private final List<AuthenticationResponse> successResponses = new LinkedList<AuthenticationResponse>();
        private final AuthenticationResponse response;

        AtnResponse(AuthenticationResponse response) {
            this.response = response;
        }

        AtnResponse(AuthenticationResponse atnResponse, List<AuthenticationResponse> successes) {
            this(atnResponse);
            this.successResponses.addAll(successes);
        }
    }
}

