/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security;

import io.helidon.security.NamedProvider;
import io.helidon.security.spi.OutboundSecurityProvider;
import io.helidon.security.spi.ProviderSelectionPolicy;
import io.helidon.security.spi.SecurityProvider;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;

class FirstProviderSelectionPolicy
implements ProviderSelectionPolicy {
    private final ProviderSelectionPolicy.Providers providers;
    private final List<OutboundSecurityProvider> outboundProviders = new LinkedList<OutboundSecurityProvider>();

    FirstProviderSelectionPolicy(ProviderSelectionPolicy.Providers providers) {
        this.providers = providers;
        providers.getProviders(OutboundSecurityProvider.class).forEach(np -> this.outboundProviders.add((OutboundSecurityProvider)np.getProvider()));
    }

    @Override
    public <T extends SecurityProvider> Optional<T> selectProvider(Class<T> providerType) {
        List<NamedProvider<T>> providers = this.providers.getProviders(providerType);
        if (providers.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(providers.get(0).getProvider());
    }

    @Override
    public List<OutboundSecurityProvider> selectOutboundProviders() {
        return this.outboundProviders;
    }

    @Override
    public <T extends SecurityProvider> Optional<T> selectProvider(Class<T> providerType, String requestedName) {
        return this.providers.getProviders(providerType).stream().filter(provider -> provider.getName().equals(requestedName)).findFirst().map(NamedProvider::getProvider);
    }
}

