/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.spi;

import io.helidon.security.AuditEvent;
import io.helidon.security.spi.SecurityProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Consumer;
import java.util.stream.Collectors;

@FunctionalInterface
public interface AuditProvider
extends SecurityProvider {
    public Consumer<TracedAuditEvent> auditConsumer();

    public static interface AuditSource {
        public static AuditSource create() {
            StackWalker walker = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);
            Optional frame = walker.walk(stream -> stream.filter(f -> !f.getClassName().startsWith("sun.")).filter(f -> !f.getClassName().startsWith("java.")).filter(f -> {
                if (f.getClassName().endsWith("Test")) {
                    return true;
                }
                return !AuditSource.isSecurityClass(f);
            }).findFirst());
            if (!frame.isPresent()) {
                frame = walker.walk(stream -> {
                    List elems = stream.filter(f -> !f.getClassName().startsWith("sun.")).filter(f -> !f.getClassName().startsWith("java.")).collect(Collectors.toList());
                    if (elems.isEmpty()) {
                        return Optional.empty();
                    }
                    return Optional.of((StackWalker.StackFrame)elems.get(elems.size() - 1));
                });
            }
            if (frame.isPresent()) {
                final StackWalker.StackFrame stackFrame = (StackWalker.StackFrame)frame.get();
                return new AuditSource(){

                    @Override
                    public Optional<String> className() {
                        return Optional.of(stackFrame.getClassName());
                    }

                    @Override
                    public Optional<String> methodName() {
                        return Optional.of(stackFrame.getMethodName());
                    }

                    @Override
                    public Optional<String> fileName() {
                        return Optional.ofNullable(stackFrame.getFileName());
                    }

                    @Override
                    public OptionalInt lineNumber() {
                        return stackFrame.getLineNumber() < 0 ? OptionalInt.empty() : OptionalInt.of(stackFrame.getLineNumber());
                    }
                };
            }
            return new AuditSource(){};
        }

        public static boolean isSecurityClass(StackWalker.StackFrame element) {
            String packageName;
            String className = element.getClassName();
            int last = className.lastIndexOf(46);
            String string = packageName = last > 0 ? className.substring(0, last) : "";
            if (packageName.equals(AuditEvent.class.getPackage().getName())) {
                return true;
            }
            return packageName.equals(AuditProvider.class.getPackage().getName());
        }

        default public Optional<String> className() {
            return Optional.empty();
        }

        default public Optional<String> methodName() {
            return Optional.empty();
        }

        default public Optional<String> fileName() {
            return Optional.empty();
        }

        default public OptionalInt lineNumber() {
            return OptionalInt.empty();
        }
    }

    public static interface TracedAuditEvent
    extends AuditEvent {
        public String tracingId();

        public AuditSource auditSource();

        default public String formatMessage() {
            List<AuditEvent.AuditParam> params = this.params();
            ArrayList msgParams = new ArrayList(params.size());
            params.forEach(auditParam -> msgParams.add(auditParam.value().orElse("")));
            return String.format(this.messageFormat(), msgParams.toArray(new Object[0]));
        }
    }
}

