/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.integration.jersey;

import io.helidon.common.serviceloader.HelidonServiceLoader;
import io.helidon.config.Config;
import io.helidon.jersey.common.InvokedResource;
import io.helidon.security.AuditEvent;
import io.helidon.security.Security;
import io.helidon.security.SecurityContext;
import io.helidon.security.SecurityLevel;
import io.helidon.security.annotations.Audited;
import io.helidon.security.annotations.Authenticated;
import io.helidon.security.annotations.Authorized;
import io.helidon.security.integration.common.ResponseTracing;
import io.helidon.security.integration.common.SecurityTracing;
import io.helidon.security.integration.jersey.FeatureConfig;
import io.helidon.security.integration.jersey.JerseySecurityContext;
import io.helidon.security.integration.jersey.SecurityDefinition;
import io.helidon.security.integration.jersey.SecurityFilterCommon;
import io.helidon.security.internal.SecurityAuditEvent;
import io.helidon.security.providers.common.spi.AnnotationAnalyzer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.Priority;
import javax.ws.rs.ConstrainedTo;
import javax.ws.rs.Path;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.server.ExtendedUriInfo;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.ServerConfig;
import org.glassfish.jersey.server.model.AbstractResourceModelVisitor;
import org.glassfish.jersey.server.model.Invocable;
import org.glassfish.jersey.server.model.Resource;
import org.glassfish.jersey.server.model.ResourceMethod;
import org.glassfish.jersey.server.model.ResourceModelVisitor;
import org.glassfish.jersey.server.model.RuntimeResource;

@Priority(value=1000)
@ConstrainedTo(value=RuntimeType.SERVER)
public class SecurityFilter
extends SecurityFilterCommon
implements ContainerRequestFilter,
ContainerResponseFilter {
    private static final Logger LOGGER = Logger.getLogger(SecurityFilter.class.getName());
    private final Map<Class<?>, SecurityDefinition> resourceClassSecurity = new ConcurrentHashMap();
    private final Map<Method, SecurityDefinition> resourceMethodSecurity = new ConcurrentHashMap<Method, SecurityDefinition>();
    private final Map<String, SecurityDefinition> subResourceMethodSecurity = new ConcurrentHashMap<String, SecurityDefinition>();
    @Context
    private ServerConfig serverConfig;
    @Context
    private SecurityContext securityContext;
    private SecurityDefinition appWideSecurity;
    private final List<AnnotationAnalyzer> analyzers = new LinkedList<AnnotationAnalyzer>();

    public SecurityFilter() {
        this.loadAnalyzers();
    }

    SecurityFilter(FeatureConfig featureConfig, Security security, ServerConfig serverConfig, SecurityContext securityContext) {
        super(security, featureConfig);
        this.serverConfig = serverConfig;
        this.securityContext = securityContext;
        this.loadAnalyzers();
    }

    private void loadAnalyzers() {
        HelidonServiceLoader.builder(ServiceLoader.load(AnnotationAnalyzer.class)).build().forEach(this.analyzers::add);
    }

    @PostConstruct
    public void postConstruct() {
        Class<?> appClass = this.getOriginalApplication().getClass();
        Config analyzersConfig = this.config("jersey.analyzers");
        this.analyzers.forEach(analyzer -> analyzer.init(analyzersConfig));
        this.appWideSecurity = this.securityForClass(appClass, null);
    }

    public void filter(ContainerRequestContext request) {
        if (this.featureConfig().shouldUsePrematchingAuthentication() && this.featureConfig().shouldUsePrematchingAuthorization()) {
            return;
        }
        this.doFilter(request, this.securityContext);
    }

    @Override
    protected void processSecurity(ContainerRequestContext request, SecurityFilterCommon.FilterContext filterContext, SecurityTracing tracing, SecurityContext securityContext) {
        if (!this.featureConfig().shouldUsePrematchingAuthentication()) {
            this.authenticate(filterContext, securityContext, tracing.atnTracing());
            LOGGER.finest(() -> "Filter after authentication. Should finish: " + filterContext.isShouldFinish());
            if (filterContext.isShouldFinish()) {
                return;
            }
            filterContext.clearTrace();
        }
        if (!this.featureConfig().shouldUsePrematchingAuthorization()) {
            this.authorize(filterContext, securityContext, tracing.atzTracing());
            LOGGER.finest(() -> "Filter completed (after authorization)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) {
        javax.ws.rs.core.SecurityContext jSecurityContext = requestContext.getSecurityContext();
        if (null == jSecurityContext) {
            return;
        }
        if (!(jSecurityContext instanceof JerseySecurityContext)) {
            return;
        }
        JerseySecurityContext jerseySecurityContext = (JerseySecurityContext)jSecurityContext;
        SecurityFilterCommon.FilterContext fc = (SecurityFilterCommon.FilterContext)requestContext.getProperty("io.helidon.security.jersey.FilterContext");
        SecurityDefinition methodSecurity = jerseySecurityContext.methodSecurity();
        SecurityContext securityContext = jerseySecurityContext.securityContext();
        if (fc.isExplicitAtz() && !securityContext.atzChecked()) {
            switch (responseContext.getStatusInfo().getFamily()) {
                case CLIENT_ERROR: 
                case SERVER_ERROR: {
                    break;
                }
                default: {
                    if (this.featureConfig().isDebug()) {
                        responseContext.setEntity((Object)"Authorization was marked as explicit, yet it was never called in resource method");
                    } else {
                        responseContext.setEntity((Object)"");
                    }
                    responseContext.setStatus(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
                    LOGGER.severe("Authorization failure. Request for" + fc.getResourcePath() + " has failed, as it was markedas explicitly authorized, yet authorization was never called on security context. The method was invoked and may have changed data. Marking as internal server error");
                    fc.setShouldFinish(true);
                }
            }
        }
        ResponseTracing responseTracing = SecurityTracing.get().responseTracing();
        try {
            if (methodSecurity.isAudited()) {
                AuditEvent.AuditSeverity auditSeverity = responseContext.getStatusInfo().getFamily() == Response.Status.Family.SUCCESSFUL ? methodSecurity.getAuditOkSeverity() : methodSecurity.getAuditErrorSeverity();
                SecurityAuditEvent auditEvent = SecurityAuditEvent.audit((AuditEvent.AuditSeverity)auditSeverity, (String)methodSecurity.getAuditEventType(), (String)methodSecurity.getAuditMessageFormat()).addParam(AuditEvent.AuditParam.plain((String)"method", (Object)fc.getMethod())).addParam(AuditEvent.AuditParam.plain((String)"path", (Object)fc.getResourcePath())).addParam(AuditEvent.AuditParam.plain((String)"status", (Object)String.valueOf(responseContext.getStatus()))).addParam(AuditEvent.AuditParam.plain((String)"subject", (Object)securityContext.user().or(() -> ((SecurityContext)securityContext).service()).orElse(SecurityContext.ANONYMOUS))).addParam(AuditEvent.AuditParam.plain((String)"transport", (Object)"http")).addParam(AuditEvent.AuditParam.plain((String)"resourceType", (Object)fc.getResourceName())).addParam(AuditEvent.AuditParam.plain((String)"targetUri", (Object)fc.getTargetUri()));
                securityContext.audit((AuditEvent)auditEvent);
            }
        }
        finally {
            responseTracing.finish();
        }
    }

    @Override
    protected SecurityFilterCommon.FilterContext initRequestFiltering(ContainerRequestContext requestContext) {
        SecurityFilterCommon.FilterContext context = new SecurityFilterCommon.FilterContext();
        InvokedResource invokedResource = InvokedResource.create((ContainerRequestContext)requestContext);
        return invokedResource.definitionMethod().map(definitionMethod -> {
            context.setMethodSecurity(this.getMethodSecurity(invokedResource, (Method)definitionMethod, (ExtendedUriInfo)requestContext.getUriInfo()));
            context.setResourceName(definitionMethod.getDeclaringClass().getSimpleName());
            return this.configureContext(context, requestContext, requestContext.getUriInfo());
        }).orElseGet(() -> {
            context.setShouldFinish(true);
            return context;
        });
    }

    @Override
    protected Logger logger() {
        return LOGGER;
    }

    private SecurityDefinition securityForClass(Class<?> theClass, SecurityDefinition parent) {
        Authenticated atn = theClass.getAnnotation(Authenticated.class);
        Authorized atz = theClass.getAnnotation(Authorized.class);
        Audited audited = theClass.getAnnotation(Audited.class);
        SecurityDefinition definition = null == parent ? new SecurityDefinition(this.featureConfig().shouldAuthorizeAnnotatedOnly()) : parent.copyMe();
        definition.add(atn);
        definition.add(atz);
        definition.add(audited);
        if (!this.featureConfig().shouldAuthenticateAnnotatedOnly()) {
            definition.requiresAuthentication(true);
        }
        HashMap<Class<? extends Annotation>, List<Annotation>> customAnnotsMap = new HashMap<Class<? extends Annotation>, List<Annotation>>();
        this.addCustomAnnotations(customAnnotsMap, theClass);
        SecurityLevel securityLevel = SecurityLevel.create((String)theClass.getName()).withClassAnnotations(customAnnotsMap).build();
        definition.getSecurityLevels().add(securityLevel);
        for (AnnotationAnalyzer analyzer : this.analyzers) {
            AnnotationAnalyzer.AnalyzerResponse analyzerResponse = null == parent ? analyzer.analyze(theClass) : analyzer.analyze(theClass, parent.analyzerResponse(analyzer));
            definition.analyzerResponse(analyzer, analyzerResponse);
        }
        return definition;
    }

    private SecurityDefinition getMethodSecurity(InvokedResource invokedResource, Method definitionMethod, ExtendedUriInfo uriInfo) {
        Class definitionClass = (Class)invokedResource.definitionClass().orElseThrow(() -> new SecurityException("Got definition method, cannot get definition class"));
        if (definitionClass.getAnnotation(Path.class) == null) {
            PathVisitor visitor = new PathVisitor();
            visitor.visit(uriInfo.getMatchedRuntimeResources());
            Collections.reverse(visitor.list);
            StringBuilder fullPathBuilder = new StringBuilder();
            LinkedList<Method> methodsToProcess = new LinkedList<Method>();
            for (Invocable m : visitor.list) {
                Method parentDefMethod = m.getDefinitionMethod();
                Class<?> parentClass = parentDefMethod.getDeclaringClass();
                fullPathBuilder.append("/").append(parentClass.getName()).append(".").append(parentDefMethod.getName());
                methodsToProcess.add(parentDefMethod);
            }
            fullPathBuilder.append("/").append(definitionClass.getName()).append(".").append(definitionMethod.getName());
            methodsToProcess.add(definitionMethod);
            String fullPath = fullPathBuilder.toString();
            if (this.subResourceMethodSecurity.containsKey(fullPath)) {
                return this.subResourceMethodSecurity.get(fullPath);
            }
            SecurityDefinition current = this.appWideSecurity;
            for (Method method : methodsToProcess) {
                Class<?> clazz = method.getDeclaringClass();
                current = this.securityForClass(clazz, current);
                Authenticated atn = method.getAnnotation(Authenticated.class);
                Authorized atz = method.getAnnotation(Authorized.class);
                Audited audited = method.getAnnotation(Audited.class);
                SecurityDefinition methodDef = current.copyMe();
                methodDef.add(atn);
                methodDef.add(atz);
                methodDef.add(audited);
                SecurityLevel currentSecurityLevel = methodDef.getSecurityLevels().get(methodDef.getSecurityLevels().size() - 1);
                HashMap<Class<? extends Annotation>, List<Annotation>> methodAnnotations = new HashMap<Class<? extends Annotation>, List<Annotation>>();
                this.addCustomAnnotations(methodAnnotations, method);
                SecurityLevel newSecurityLevel = SecurityLevel.create((SecurityLevel)currentSecurityLevel).withMethodName(method.getName()).withMethodAnnotations(methodAnnotations).build();
                methodDef.getSecurityLevels().set(methodDef.getSecurityLevels().size() - 1, newSecurityLevel);
                for (AnnotationAnalyzer analyzer : this.analyzers) {
                    AnnotationAnalyzer.AnalyzerResponse analyzerResponse = analyzer.analyze(method, current.analyzerResponse(analyzer));
                    methodDef.analyzerResponse(analyzer, analyzerResponse);
                }
                current = methodDef;
            }
            this.subResourceMethodSecurity.put(fullPath, current);
            return current;
        }
        if (this.resourceMethodSecurity.containsKey(definitionMethod)) {
            return this.resourceMethodSecurity.get(definitionMethod);
        }
        SecurityDefinition definition = this.resourceClassSecurity.computeIfAbsent(definitionClass, aClass -> this.securityForClass(definitionClass, this.appWideSecurity));
        Authenticated atn = definitionMethod.getAnnotation(Authenticated.class);
        Authorized atz = definitionMethod.getAnnotation(Authorized.class);
        Audited audited = definitionMethod.getAnnotation(Audited.class);
        SecurityDefinition methodDef = definition.copyMe();
        methodDef.add(atn);
        methodDef.add(atz);
        methodDef.add(audited);
        int index = methodDef.getSecurityLevels().size() - 1;
        SecurityLevel currentSecurityLevel = methodDef.getSecurityLevels().get(index);
        HashMap<Class<? extends Annotation>, List<Annotation>> methodLevelAnnots = new HashMap<Class<? extends Annotation>, List<Annotation>>();
        this.addCustomAnnotations(methodLevelAnnots, definitionMethod);
        methodDef.getSecurityLevels().set(index, SecurityLevel.create((SecurityLevel)currentSecurityLevel).withMethodName(definitionMethod.getName()).withMethodAnnotations(methodLevelAnnots).build());
        this.resourceMethodSecurity.put(definitionMethod, methodDef);
        for (AnnotationAnalyzer analyzer : this.analyzers) {
            AnnotationAnalyzer.AnalyzerResponse analyzerResponse = analyzer.analyze(definitionMethod, definition.analyzerResponse(analyzer));
            methodDef.analyzerResponse(analyzer, analyzerResponse);
        }
        return methodDef;
    }

    private void addCustomAnnotations(Map<Class<? extends Annotation>, List<Annotation>> customAnnotsMap, Class<?> theClass) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = theClass.getAnnotations()) {
            this.addToMap(annotation.annotationType(), customAnnotsMap, annotation);
        }
    }

    private void addToMap(Class<? extends Annotation> annotClass, Map<Class<? extends Annotation>, List<Annotation>> customAnnotsMap, Annotation ... annot) {
        customAnnotsMap.computeIfAbsent(annotClass, key -> new LinkedList()).addAll(Arrays.asList(annot));
    }

    private void addCustomAnnotations(Map<Class<? extends Annotation>, List<Annotation>> customAnnotsMap, Method theMethod) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = theMethod.getAnnotations()) {
            this.addToMap(annotation.annotationType(), customAnnotsMap, annotation);
        }
    }

    private Application getOriginalApplication() {
        Application wrappedApplication;
        if (!(this.serverConfig instanceof ResourceConfig)) {
            throw new IllegalStateException("Could not get Application instance. Incompatible version of Jersey?");
        }
        ResourceConfig resourceConfig = (ResourceConfig)this.serverConfig;
        Application application = resourceConfig.getApplication();
        while (application instanceof ResourceConfig && (wrappedApplication = ((ResourceConfig)application).getApplication()) != application) {
            application = wrappedApplication;
        }
        return application;
    }

    List<AnnotationAnalyzer> analyzers() {
        return this.analyzers;
    }

    private static final class PathVisitor
    extends AbstractResourceModelVisitor {
        private final List<Invocable> list = new LinkedList<Invocable>();

        private PathVisitor() {
        }

        public void visitResource(Resource resource) {
            if (resource.getResourceLocator() != null) {
                resource.getResourceLocator().accept((ResourceModelVisitor)this);
            }
        }

        public void visitChildResource(Resource resource) {
            this.visitResource(resource);
        }

        public void visitResourceMethod(ResourceMethod method) {
            this.list.add(method.getInvocable());
        }

        public void visitRuntimeResource(RuntimeResource runtimeResource) {
            for (Resource resource : runtimeResource.getResources()) {
                resource.accept((ResourceModelVisitor)this);
            }
        }

        public void visit(List<RuntimeResource> runtimeResources) {
            for (RuntimeResource runtimeResource : runtimeResources) {
                runtimeResource.accept((ResourceModelVisitor)this);
            }
        }
    }
}

