/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.integration.jersey;

import io.helidon.security.AuditEvent;
import io.helidon.security.SecurityLevel;
import io.helidon.security.annotations.Audited;
import io.helidon.security.annotations.Authenticated;
import io.helidon.security.annotations.Authorized;
import io.helidon.security.providers.common.spi.AnnotationAnalyzer;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

class SecurityDefinition {
    private final Map<AnnotationAnalyzer, AnnotationAnalyzer.AnalyzerResponse> analyzerResponses = new IdentityHashMap<AnnotationAnalyzer, AnnotationAnalyzer.AnalyzerResponse>();
    private final List<SecurityLevel> securityLevels = new ArrayList<SecurityLevel>();
    private boolean requiresAuthentication;
    private boolean authnOptional;
    private boolean authorizeByDefault;
    private boolean atzExplicit;
    private String authenticator;
    private String authorizer;
    private boolean audited;
    private String auditEventType;
    private String auditMessageFormat;
    private AuditEvent.AuditSeverity auditOkSeverity;
    private AuditEvent.AuditSeverity auditErrorSeverity;
    private Boolean requiresAuthorization;

    private SecurityDefinition() {
    }

    SecurityDefinition(boolean authorizeAnnotatedOnly) {
        this.authorizeByDefault = !authorizeAnnotatedOnly;
    }

    SecurityDefinition copyMe() {
        SecurityDefinition result = new SecurityDefinition();
        result.requiresAuthentication = this.requiresAuthentication;
        result.authnOptional = this.authnOptional;
        result.authenticator = this.authenticator;
        result.authorizer = this.authorizer;
        result.securityLevels.addAll(this.securityLevels);
        result.authorizeByDefault = this.authorizeByDefault;
        result.atzExplicit = this.atzExplicit;
        return result;
    }

    public void add(Authenticated atn) {
        if (null == atn) {
            return;
        }
        this.requiresAuthentication = atn.value();
        this.authnOptional = atn.optional();
        this.authenticator = "".equals(atn.provider()) ? null : atn.provider();
    }

    public void add(Authorized atz) {
        if (null == atz) {
            return;
        }
        this.requiresAuthorization = atz.value();
        this.authorizer = "".equals(atz.provider()) ? null : atz.provider();
        this.atzExplicit = atz.explicit();
    }

    void add(Audited audited) {
        if (null == audited) {
            return;
        }
        this.audited = true;
        this.auditEventType = this.checkDefault(this.auditEventType, audited.value(), "request");
        this.auditMessageFormat = this.checkDefault(this.auditMessageFormat, audited.messageFormat(), "%3$s %1$s \"%2$s\" %5$s %6$s requested by %4$s");
        this.auditOkSeverity = this.checkDefault(this.auditOkSeverity, audited.okSeverity(), Audited.DEFAULT_OK_SEVERITY);
        this.auditErrorSeverity = this.checkDefault(this.auditErrorSeverity, audited.errorSeverity(), Audited.DEFAULT_ERROR_SEVERITY);
    }

    void requiresAuthentication(boolean atn) {
        this.requiresAuthentication = atn;
    }

    void setRequiresAuthorization(boolean atz) {
        this.requiresAuthorization = atz;
    }

    private <T> T checkDefault(T currentValue, T annotValue, T defaultValue) {
        if (null == currentValue) {
            return annotValue;
        }
        if (currentValue.equals(defaultValue)) {
            return annotValue;
        }
        return currentValue;
    }

    boolean requiresAuthentication() {
        return this.requiresAuthentication;
    }

    boolean authenticationOptional() {
        return this.authnOptional;
    }

    boolean requiresAuthorization() {
        if (null != this.requiresAuthorization) {
            return this.requiresAuthorization;
        }
        int count = 0;
        for (SecurityLevel securityLevel : this.securityLevels) {
            count += securityLevel.getClassLevelAnnotations().size();
            count += securityLevel.getMethodLevelAnnotations().size();
        }
        return count != 0 || this.authorizeByDefault;
    }

    public boolean isAtzExplicit() {
        return this.atzExplicit;
    }

    String getAuthenticator() {
        return this.authenticator;
    }

    String getAuthorizer() {
        return this.authorizer;
    }

    public List<SecurityLevel> getSecurityLevels() {
        return this.securityLevels;
    }

    public boolean isAudited() {
        return this.audited;
    }

    public String getAuditEventType() {
        return this.auditEventType;
    }

    public String getAuditMessageFormat() {
        return this.auditMessageFormat;
    }

    public AuditEvent.AuditSeverity getAuditOkSeverity() {
        return this.auditOkSeverity;
    }

    public AuditEvent.AuditSeverity getAuditErrorSeverity() {
        return this.auditErrorSeverity;
    }

    public AnnotationAnalyzer.AnalyzerResponse analyzerResponse(AnnotationAnalyzer analyzer) {
        return this.analyzerResponses.get(analyzer);
    }

    public void analyzerResponse(AnnotationAnalyzer analyzer, AnnotationAnalyzer.AnalyzerResponse analyzerResponse) {
        this.analyzerResponses.put(analyzer, analyzerResponse);
        switch (analyzerResponse.authenticationResponse()) {
            case REQUIRED: {
                this.requiresAuthentication = true;
                this.authnOptional = false;
                break;
            }
            case OPTIONAL: {
                this.requiresAuthentication = true;
                this.authnOptional = true;
                break;
            }
            case FORBIDDEN: {
                this.requiresAuthentication = false;
                this.authnOptional = false;
                break;
            }
        }
        switch (analyzerResponse.authorizationResponse()) {
            case REQUIRED: {
                this.requiresAuthorization = true;
                break;
            }
            case OPTIONAL: {
                this.requiresAuthorization = true;
                break;
            }
            case FORBIDDEN: {
                this.requiresAuthorization = false;
                break;
            }
        }
        this.authenticator = analyzerResponse.authenticator().orElse(this.authenticator);
        this.authorizer = analyzerResponse.authorizer().orElse(this.authorizer);
    }
}

