/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.integration.webserver;

import io.helidon.common.http.Http;
import io.helidon.config.Config;
import io.helidon.config.ConfigValue;
import io.helidon.security.EndpointConfig;
import io.helidon.security.Security;
import io.helidon.security.SecurityContext;
import io.helidon.security.SecurityEnvironment;
import io.helidon.security.integration.webserver.SecurityHandler;
import io.helidon.webserver.Handler;
import io.helidon.webserver.Routing;
import io.helidon.webserver.ServerRequest;
import io.helidon.webserver.ServerResponse;
import io.helidon.webserver.Service;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public final class WebSecurity
implements Service {
    public static final String CONTEXT_ADD_HEADERS = "security.addHeaders";
    private static final Logger LOGGER = Logger.getLogger(WebSecurity.class.getName());
    private static final AtomicInteger SECURITY_COUNTER = new AtomicInteger();
    private final Security security;
    private final Config config;
    private final SecurityHandler defaultHandler;

    private WebSecurity(Security security, Config config) {
        this(security, config, SecurityHandler.create());
    }

    private WebSecurity(Security security, Config config, SecurityHandler defaultHandler) {
        this.security = security;
        this.config = config;
        this.defaultHandler = defaultHandler;
    }

    public static WebSecurity create(Security security) {
        return new WebSecurity(security, null);
    }

    public static WebSecurity create(Config config) {
        Security security = Security.create((Config)config);
        return WebSecurity.create(security, config);
    }

    public static WebSecurity create(Security security, Config config) {
        return new WebSecurity(security, config);
    }

    public static SecurityHandler secure() {
        return SecurityHandler.create().authenticate().authorize();
    }

    public static SecurityHandler authenticate() {
        return SecurityHandler.create().authenticate();
    }

    public static SecurityHandler audit() {
        return SecurityHandler.create().audit();
    }

    public static SecurityHandler authenticator(String explicitAuthenticator) {
        return SecurityHandler.create().authenticate().authenticator(explicitAuthenticator);
    }

    public static SecurityHandler authorizer(String explicitAuthorizer) {
        return SecurityHandler.create().authenticate().authorize().authorizer(explicitAuthorizer);
    }

    public static SecurityHandler rolesAllowed(String ... roles) {
        return SecurityHandler.create().rolesAllowed(roles);
    }

    public static SecurityHandler allowAnonymous() {
        return SecurityHandler.create().authenticate().authenticationOptional();
    }

    public static SecurityHandler authorize() {
        return SecurityHandler.create().authorize();
    }

    public static SecurityHandler enforce() {
        return SecurityHandler.create();
    }

    public WebSecurity securityDefaults(SecurityHandler defaultHandler) {
        Objects.requireNonNull(defaultHandler, "Default security handler must not be null");
        return new WebSecurity(this.security, this.config, defaultHandler);
    }

    public void update(Routing.Rules routing) {
        if (!this.security.enabled()) {
            LOGGER.info("Security is disabled. Not registering any security handlers");
            return;
        }
        routing.any(new Handler[]{this::registerContext});
        if (null != this.config) {
            this.registerRouting(routing);
        }
    }

    private void registerContext(ServerRequest req, ServerResponse res) {
        HashMap allHeaders = new HashMap(req.headers().toMap());
        Optional newHeaders = req.context().get((Object)CONTEXT_ADD_HEADERS, Map.class);
        newHeaders.ifPresent(allHeaders::putAll);
        if (!req.context().get(SecurityContext.class).isPresent()) {
            SecurityEnvironment env = this.security.environmentBuilder().targetUri(req.uri()).path(req.path().toString()).method(req.method().name()).addAttribute("userIp", (Object)req.remoteAddress()).addAttribute("userPort", (Object)req.remotePort()).transport(req.isSecure() ? "https" : "http").headers(allHeaders).build();
            EndpointConfig ec = EndpointConfig.builder().build();
            SecurityContext.Builder contextBuilder = this.security.contextBuilder(String.valueOf(SECURITY_COUNTER.incrementAndGet())).env(env).endpointConfig(ec);
            req.spanContext().ifPresent(arg_0 -> ((SecurityContext.Builder)contextBuilder).tracingSpan(arg_0));
            SecurityContext context = contextBuilder.build();
            req.context().register((Object)context);
            req.context().register((Object)this.defaultHandler);
        }
        req.next();
    }

    private void registerRouting(Routing.Rules routing) {
        Config wsConfig = this.config.get("web-server");
        SecurityHandler defaults = SecurityHandler.create(wsConfig.get("defaults"), this.defaultHandler);
        wsConfig.get("paths").asNodeList().ifPresent(configs -> {
            for (Config pathConfig : configs) {
                List methods = ((List)pathConfig.get("methods").asNodeList().orElse(List.of())).stream().map(Config::asString).map(ConfigValue::get).map(Http.RequestMethod::create).collect(Collectors.toList());
                String path = (String)pathConfig.get("path").asString().orElseThrow(() -> new SecurityException(pathConfig.key() + " must contain path key with a path to register to web server"));
                if (methods.isEmpty()) {
                    routing.any(path, new Handler[]{SecurityHandler.create(pathConfig, defaults)});
                    continue;
                }
                routing.anyOf(methods, path, new Handler[]{SecurityHandler.create(pathConfig, defaults)});
            }
        });
    }
}

