/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.servicecommon.restcdi;

import io.helidon.config.Config;
import io.helidon.config.mp.MpConfig;
import io.helidon.microprofile.server.RoutingBuilders;
import io.helidon.microprofile.server.ServerCdiExtension;
import io.helidon.servicecommon.rest.RestServiceSupport;
import io.helidon.webserver.Routing;
import java.lang.annotation.Annotation;
import java.lang.reflect.Executable;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Priority;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Initialized;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.AnnotatedMember;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessManagedBean;
import javax.enterprise.inject.spi.ProcessProducerField;
import javax.enterprise.inject.spi.ProcessProducerMethod;
import javax.interceptor.Interceptor;
import org.eclipse.microprofile.config.ConfigProvider;

public abstract class HelidonRestCdiExtension<T extends RestServiceSupport>
implements Extension {
    private final Map<Bean<?>, AnnotatedMember<?>> producers = new HashMap();
    private final Set<Class<?>> annotatedClasses = new HashSet();
    private final Set<Class<?>> annotatedClassesProcessed = new HashSet();
    private final Logger logger;
    private final Function<Config, T> serviceSupportFactory;
    private final String configPrefix;
    private T serviceSupport = null;

    protected HelidonRestCdiExtension(Logger logger, Function<Config, T> serviceSupportFactory, String configPrefix) {
        this.logger = logger;
        this.serviceSupportFactory = serviceSupportFactory;
        this.configPrefix = configPrefix;
    }

    protected void clearAnnotationInfo(@Observes AfterDeploymentValidation adv) {
        if (this.logger.isLoggable(Level.FINE)) {
            HashSet annotatedClassesIgnored = new HashSet(this.annotatedClasses);
            annotatedClassesIgnored.removeAll(this.annotatedClassesProcessed);
            if (!annotatedClassesIgnored.isEmpty()) {
                this.logger.log(Level.FINE, () -> "Classes originally found with selected annotations that were not processed, probably because they were vetoed:" + annotatedClassesIgnored.toString());
            }
        }
        this.annotatedClasses.clear();
        this.annotatedClassesProcessed.clear();
    }

    protected void observeManagedBeans(@Observes ProcessManagedBean<?> pmb) {
        AnnotatedType type = pmb.getAnnotatedBeanClass();
        Class clazz = type.getJavaClass();
        if (!this.annotatedClasses.contains(clazz)) {
            return;
        }
        this.annotatedClassesProcessed.add(clazz);
        this.logger.log(Level.FINE, () -> "Processing managed bean " + clazz.getName());
        this.processManagedBean(pmb);
    }

    protected abstract void processManagedBean(ProcessManagedBean<?> var1);

    protected boolean isConcreteNonInterceptor(ProcessAnnotatedType<?> pat) {
        AnnotatedType annotatedType = pat.getAnnotatedType();
        Class clazz = annotatedType.getJavaClass();
        if (annotatedType.isAnnotationPresent(Interceptor.class) || Modifier.isAbstract(clazz.getModifiers())) {
            this.logger.log(Level.FINER, () -> "Ignoring " + clazz.getName() + " with annotations " + annotatedType.getAnnotations() + " for later processing: " + (Modifier.isAbstract(clazz.getModifiers()) ? "abstract " : "") + (annotatedType.isAnnotationPresent(Interceptor.class) ? "interceptor " : ""));
            return false;
        }
        this.logger.log(Level.FINE, () -> "Accepting " + clazz.getName() + " for later bean processing");
        return true;
    }

    protected void recordAnnotatedType(ProcessAnnotatedType<?> pat) {
        this.annotatedClasses.add(pat.getAnnotatedType().getJavaClass());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isOwnProducerOrNonDefaultQualified(Bean<?> bean, Class<?> ownProducerClass) {
        if (ownProducerClass.equals(bean.getBeanClass())) return true;
        if (!bean.getQualifiers().stream().noneMatch(Default.class::isInstance)) return false;
        return true;
    }

    protected void recordProducerField(ProcessProducerField<?, ?> ppf) {
        this.recordProducerMember("recordProducerField", (AnnotatedMember<?>)ppf.getAnnotatedProducerField(), (Bean<?>)ppf.getBean());
    }

    protected void recordProducerMethod(ProcessProducerMethod<?, ?> ppm) {
        this.recordProducerMember("recordProducerMethod", (AnnotatedMember<?>)ppm.getAnnotatedProducerMethod(), (Bean<?>)ppm.getBean());
    }

    protected Map<Bean<?>, AnnotatedMember<?>> producers() {
        return this.producers;
    }

    protected Routing.Builder registerService(@Observes @Priority(value=1010) @Initialized(value=ApplicationScoped.class) Object adv, BeanManager bm, ServerCdiExtension server) {
        Config config = MpConfig.toHelidonConfig((org.eclipse.microprofile.config.Config)ConfigProvider.getConfig()).get(this.configPrefix);
        this.serviceSupport = (RestServiceSupport)this.serviceSupportFactory.apply(config);
        RoutingBuilders routingBuilders = RoutingBuilders.create((Config)config);
        this.serviceSupport.configureEndpoint((Routing.Rules)routingBuilders.defaultRoutingBuilder(), (Routing.Rules)routingBuilders.routingBuilder());
        return routingBuilders.defaultRoutingBuilder();
    }

    protected T serviceSupport() {
        return this.serviceSupport;
    }

    private void recordProducerMember(String logPrefix, AnnotatedMember<?> member, Bean<?> bean) {
        this.logger.log(Level.FINE, () -> logPrefix + " " + bean.getBeanClass());
        this.producers.put(bean, member);
    }

    protected static class WorkItemsManager<W> {
        private final Map<Executable, Map<Class<? extends Annotation>, List<W>>> workItemsByExecutable = new HashMap<Executable, Map<Class<? extends Annotation>, List<W>>>();

        public static <W> WorkItemsManager<W> create() {
            return new WorkItemsManager<W>();
        }

        private WorkItemsManager() {
        }

        public void put(Executable executable, Class<? extends Annotation> annotationType, W workItem) {
            List workItems = this.workItemsByExecutable.computeIfAbsent(executable, e -> new HashMap()).computeIfAbsent(annotationType, t -> new ArrayList());
            if (!workItems.contains(workItem)) {
                workItems.add(workItem);
            }
        }

        public Iterable<W> workItems(Executable executable, Class<? extends Annotation> annotationType) {
            return this.workItemsByExecutable.getOrDefault(executable, Collections.emptyMap()).getOrDefault(annotationType, Collections.emptyList());
        }
    }
}

