/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.servicecommon.restcdi;

import io.helidon.servicecommon.restcdi.InterceptionRunner;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.interceptor.InvocationContext;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.CompletionCallback;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.container.TimeoutHandler;

class InterceptionRunnerImpl
implements InterceptionRunner {
    private static final Logger LOGGER = Logger.getLogger(InterceptionRunnerImpl.class.getName());
    private static final String POST_INVOCATION_HANDLER_FAILURE = "Interceptor post-invocation handler failed; continuing";
    private static final String ERROR_DURING_INTERCEPTION = "Error during interception";
    private static final InterceptionRunner INSTANCE = new InterceptionRunnerImpl();
    private static final Map<Method, Integer> ASYNC_RESPONSE_SLOTS = new ConcurrentHashMap<Method, Integer>();

    InterceptionRunnerImpl() {
    }

    static InterceptionRunner create(Executable executable) {
        if (executable instanceof Constructor) {
            return INSTANCE;
        }
        if (executable instanceof Method) {
            int asyncResponseSlot = InterceptionRunnerImpl.asyncResponseSlot((Method)executable);
            return asyncResponseSlot >= 0 ? AsyncMethodRunnerImpl.create(asyncResponseSlot) : INSTANCE;
        }
        throw new IllegalArgumentException("Executable " + executable.getName() + " is not a constructor or method");
    }

    @Override
    public <T> Object run(InvocationContext context, Iterable<T> workItems, InterceptionRunner.PreInvocationHandler<T> preInvocationHandler) throws Exception {
        for (T workItem : workItems) {
            preInvocationHandler.accept(context, workItem);
        }
        return context.proceed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Object run(InvocationContext context, Iterable<T> workItems, InterceptionRunner.PreInvocationHandler<T> preInvocationHandler, InterceptionRunner.PostCompletionHandler<T> postCompletionHandler) throws Exception {
        Exception escapingException;
        for (T workItem : workItems) {
            preInvocationHandler.accept(context, workItem);
        }
        Object result = null;
        Exception exceptionFromContextProceed = null;
        try {
            result = context.proceed();
        }
        catch (Exception e) {
            exceptionFromContextProceed = e;
        }
        finally {
            escapingException = InterceptionRunnerImpl.processPostInvocationHandlers(context, exceptionFromContextProceed, workItems, postCompletionHandler, RuntimeException::new);
        }
        if (escapingException != null) {
            LOGGER.log(Level.WARNING, ERROR_DURING_INTERCEPTION, escapingException);
            throw escapingException;
        }
        return result;
    }

    private static <T, X extends Throwable> X processPostInvocationHandlers(InvocationContext context, X fromContextProceed, Iterable<T> workItems, InterceptionRunner.PostCompletionHandler<T> postCompletionHandler, Function<String, ? extends X> factory) {
        Object escaping = fromContextProceed;
        for (T workItem : workItems) {
            try {
                postCompletionHandler.accept(context, fromContextProceed, workItem);
            }
            catch (Exception handlerException) {
                if (escaping == null) {
                    escaping = (Throwable)factory.apply("Exception(s) invoking post-completion handler(s)");
                }
                escaping.addSuppressed(handlerException);
            }
        }
        return escaping;
    }

    private static int asyncResponseSlot(Method interceptedMethod) {
        return ASYNC_RESPONSE_SLOTS.computeIfAbsent(interceptedMethod, InterceptionRunnerImpl::computeAsyncResponseSlot);
    }

    private static int computeAsyncResponseSlot(Method interceptedMethod) {
        int newResult = 0;
        for (Parameter p : interceptedMethod.getParameters()) {
            if (AsyncResponse.class.isAssignableFrom(p.getType()) && p.getAnnotation(Suspended.class) != null) {
                return newResult;
            }
            ++newResult;
        }
        return -1;
    }

    private static class FinishCallback<T>
    implements CompletionCallback {
        private static final Logger LOGGER = Logger.getLogger(FinishCallback.class.getName());
        private final InvocationContext context;
        private final ThrowableCapturingAsyncResponse throwableCapturingAsyncResponse;
        private final InterceptionRunner.PostCompletionHandler<T> postCompletionHandler;
        private final Iterable<T> workItems;

        static <T> FinishCallback<T> create(InvocationContext context, ThrowableCapturingAsyncResponse throwableCapturingAsyncResponse, InterceptionRunner.PostCompletionHandler<T> postCompletionHandler, Iterable<T> workItems) {
            return new FinishCallback<T>(context, throwableCapturingAsyncResponse, postCompletionHandler, workItems);
        }

        private FinishCallback(InvocationContext context, ThrowableCapturingAsyncResponse throwableCapturingAsyncResponse, InterceptionRunner.PostCompletionHandler<T> postCompletionHandler, Iterable<T> workItems) {
            this.context = context;
            this.throwableCapturingAsyncResponse = throwableCapturingAsyncResponse;
            this.postCompletionHandler = postCompletionHandler;
            this.workItems = workItems;
        }

        public void onComplete(Throwable throwable) {
            if (throwable != null) {
                LOGGER.log(Level.FINE, "Unmapped throwable detected by interceptor async callback", throwable);
            } else if (this.throwableCapturingAsyncResponse.throwable() != null) {
                throwable = this.throwableCapturingAsyncResponse.throwable();
                LOGGER.log(Level.FINE, "Mapped throwable detected by interceptor async callback", throwable);
            }
            Throwable reportingThrowable = InterceptionRunnerImpl.processPostInvocationHandlers(this.context, throwable, this.workItems, this.postCompletionHandler, RuntimeException::new);
            if (reportingThrowable != null) {
                LOGGER.log(Level.WARNING, InterceptionRunnerImpl.POST_INVOCATION_HANDLER_FAILURE, reportingThrowable);
            }
        }
    }

    private static class ThrowableCapturingAsyncResponse
    implements AsyncResponse {
        private final AsyncResponse delegate;
        private Throwable throwable = null;

        private ThrowableCapturingAsyncResponse(AsyncResponse delegate) {
            this.delegate = delegate;
        }

        Throwable throwable() {
            return this.throwable;
        }

        public boolean resume(Object response) {
            return this.delegate.resume(response);
        }

        public boolean resume(Throwable response) {
            this.throwable = response;
            return this.delegate.resume(response);
        }

        public boolean cancel() {
            return this.delegate.cancel();
        }

        public boolean cancel(int retryAfter) {
            return this.delegate.cancel(retryAfter);
        }

        public boolean cancel(Date retryAfter) {
            return this.delegate.cancel(retryAfter);
        }

        public boolean isSuspended() {
            return this.delegate.isSuspended();
        }

        public boolean isCancelled() {
            return this.delegate.isCancelled();
        }

        public boolean isDone() {
            return this.delegate.isDone();
        }

        public boolean setTimeout(long time, TimeUnit unit) {
            return this.delegate.setTimeout(time, unit);
        }

        public void setTimeoutHandler(TimeoutHandler handler) {
            this.delegate.setTimeoutHandler(handler);
        }

        public Collection<Class<?>> register(Class<?> callback) {
            return this.delegate.register(callback);
        }

        public Map<Class<?>, Collection<Class<?>>> register(Class<?> callback, Class<?> ... callbacks) {
            return this.delegate.register(callback, (Class[])callbacks);
        }

        public Collection<Class<?>> register(Object callback) {
            return this.delegate.register(callback);
        }

        public Map<Class<?>, Collection<Class<?>>> register(Object callback, Object ... callbacks) {
            return this.delegate.register(callback, callbacks);
        }
    }

    private static class AsyncMethodRunnerImpl
    extends InterceptionRunnerImpl {
        private final int asyncResponseSlot;

        static InterceptionRunner create(int asyncResponseSlot) {
            return new AsyncMethodRunnerImpl(asyncResponseSlot);
        }

        private AsyncMethodRunnerImpl(int asyncResponseSlot) {
            this.asyncResponseSlot = asyncResponseSlot;
        }

        @Override
        public <T> Object run(InvocationContext context, Iterable<T> workItems, InterceptionRunner.PreInvocationHandler<T> preInvocationHandler, InterceptionRunner.PostCompletionHandler<T> postCompletionHandler) throws Exception {
            Objects.requireNonNull(postCompletionHandler, "postCompletionHandler");
            for (T workItem : workItems) {
                preInvocationHandler.accept(context, workItem);
            }
            Object[] params = context.getParameters();
            AsyncResponse asyncResponse = (AsyncResponse)AsyncResponse.class.cast(context.getParameters()[this.asyncResponseSlot]);
            ThrowableCapturingAsyncResponse throwableCapturingAsyncResponse = new ThrowableCapturingAsyncResponse(asyncResponse);
            params[this.asyncResponseSlot] = throwableCapturingAsyncResponse;
            context.setParameters(params);
            throwableCapturingAsyncResponse.register(FinishCallback.create(context, throwableCapturingAsyncResponse, postCompletionHandler, workItems));
            return context.proceed();
        }

        public String toString() {
            return new StringJoiner(", ", AsyncMethodRunnerImpl.class.getSimpleName() + "[", "]").add("asyncResponseSlot=" + this.asyncResponseSlot).toString();
        }
    }
}

