/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.tracing.config;

import io.helidon.common.OptionalHelper;
import io.helidon.config.Config;
import io.helidon.tracing.config.SpanLogTracingConfig;
import io.helidon.tracing.config.Traceable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public abstract class SpanTracingConfig
extends Traceable {
    public static final SpanTracingConfig DISABLED = SpanTracingConfig.builder("disabled").enabled(false).build();
    public static final SpanTracingConfig ENABLED = SpanTracingConfig.builder("enabled").build();

    protected SpanTracingConfig(String name) {
        super(name);
    }

    public String toString() {
        return "SpanTracingConfig(" + this.name() + ")";
    }

    static SpanTracingConfig merge(final SpanTracingConfig older, final SpanTracingConfig newer) {
        return new SpanTracingConfig(newer.name()){

            @Override
            public Optional<String> newName() {
                return OptionalHelper.from(newer.newName()).or(older::newName).asOptional();
            }

            @Override
            public Optional<Boolean> isEnabled() {
                return OptionalHelper.from(newer.isEnabled()).or(older::isEnabled).asOptional();
            }

            @Override
            public Optional<SpanLogTracingConfig> getSpanLog(String name) {
                Optional<SpanLogTracingConfig> newLog = newer.getSpanLog(name);
                Optional<SpanLogTracingConfig> oldLog = older.getSpanLog(name);
                if (newLog.isPresent() && oldLog.isPresent()) {
                    return Optional.of(SpanLogTracingConfig.merge(oldLog.get(), newLog.get()));
                }
                if (newLog.isPresent()) {
                    return newLog;
                }
                return oldLog;
            }
        };
    }

    public abstract Optional<String> newName();

    protected abstract Optional<SpanLogTracingConfig> getSpanLog(String var1);

    public final SpanLogTracingConfig spanLog(String name) {
        if (this.enabled()) {
            return this.getSpanLog(name).orElse(SpanLogTracingConfig.ENABLED);
        }
        return SpanLogTracingConfig.DISABLED;
    }

    public boolean logEnabled(String logName, boolean defaultValue) {
        if (this.enabled()) {
            return this.getSpanLog(logName).map(Traceable::enabled).orElse(defaultValue);
        }
        return false;
    }

    public static Builder builder(String name) {
        return new Builder(name);
    }

    public static SpanTracingConfig create(String name, Config config) {
        return SpanTracingConfig.builder(name).config(config).build();
    }

    public static final class Builder
    implements io.helidon.common.Builder<SpanTracingConfig> {
        private final Map<String, SpanLogTracingConfig> spanLogMap = new HashMap<String, SpanLogTracingConfig>();
        private final String name;
        private Optional<Boolean> enabled = Optional.empty();
        private String newName;

        private Builder(String name) {
            this.name = name;
        }

        public SpanTracingConfig build() {
            final HashMap<String, SpanLogTracingConfig> finalSpanLogMap = new HashMap<String, SpanLogTracingConfig>(this.spanLogMap);
            final Optional<String> finalNewName = Optional.ofNullable(this.newName);
            final Optional<Boolean> finalEnabled = this.enabled;
            return new SpanTracingConfig(this.name){

                @Override
                public Optional<String> newName() {
                    return finalNewName;
                }

                @Override
                public Optional<Boolean> isEnabled() {
                    return finalEnabled;
                }

                @Override
                protected Optional<SpanLogTracingConfig> getSpanLog(String name) {
                    if (enabled.orElse(true).booleanValue()) {
                        return Optional.ofNullable((SpanLogTracingConfig)finalSpanLogMap.get(name));
                    }
                    return Optional.of(SpanLogTracingConfig.DISABLED);
                }
            };
        }

        public Builder enabled(boolean enabled) {
            this.enabled = Optional.of(enabled);
            return this;
        }

        public Builder newName(String newName) {
            this.newName = newName;
            return this;
        }

        public Builder addSpanLog(SpanLogTracingConfig spanLogTracingConfig) {
            this.spanLogMap.put(spanLogTracingConfig.name(), spanLogTracingConfig);
            return this;
        }

        public Builder config(Config config) {
            config.get("enabled").asBoolean().ifPresent(this::enabled);
            config.get("new-name").asString().ifPresent(this::newName);
            config.get("logs").asNodeList().ifPresent(nodes -> nodes.forEach(node -> this.addSpanLog(SpanLogTracingConfig.create((String)node.get("name").asString().get(), node))));
            return this;
        }
    }
}

