/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.tracing.opentracing;

import io.helidon.tracing.Scope;
import io.helidon.tracing.Span;
import io.helidon.tracing.SpanContext;
import io.helidon.tracing.opentracing.OpenTracingContext;
import io.helidon.tracing.opentracing.OpenTracingScope;
import io.opentracing.Tracer;
import io.opentracing.tag.Tags;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

class OpenTracingSpan
implements Span {
    private final Tracer tracer;
    private final io.opentracing.Span delegate;

    OpenTracingSpan(Tracer tracer, io.opentracing.Span delegate) {
        this.tracer = tracer;
        this.delegate = delegate;
    }

    public Span tag(String key, String value) {
        this.delegate.setTag(key, value);
        return this;
    }

    public Span tag(String key, Boolean value) {
        this.delegate.setTag(key, value.booleanValue());
        return this;
    }

    public Span tag(String key, Number value) {
        this.delegate.setTag(key, value);
        return this;
    }

    public void status(Span.Status status) {
        if (status == Span.Status.ERROR) {
            Tags.ERROR.set(this.delegate, Boolean.valueOf(true));
        }
    }

    public SpanContext context() {
        return new OpenTracingContext(this.delegate.context());
    }

    public void addEvent(String name, Map<String, ?> attributes) {
        HashMap newMap = new HashMap(attributes);
        newMap.put("event", name);
        this.delegate.log(newMap);
    }

    public void end() {
        this.delegate.finish();
    }

    public void end(Throwable throwable) {
        this.status(Span.Status.ERROR);
        this.delegate.log(Map.of("event", "error", "error.kind", "Exception", "error.object", throwable, "message", throwable.getMessage()));
        this.delegate.finish();
    }

    public Scope activate() {
        return new OpenTracingScope(this.tracer.activateSpan(this.delegate));
    }

    public Span baggage(String key, String value) {
        Objects.requireNonNull(key, "Baggage Key cannot be null");
        Objects.requireNonNull(value, "Baggage Value cannot be null");
        this.delegate.setBaggageItem(key, value);
        return this;
    }

    public Optional<String> baggage(String key) {
        Objects.requireNonNull(key, "Baggage Key cannot be null");
        return Optional.ofNullable(this.delegate.getBaggageItem(key));
    }

    public <T> T unwrap(Class<T> spanClass) {
        if (spanClass.isAssignableFrom(this.delegate.getClass())) {
            return spanClass.cast(this.delegate);
        }
        throw new IllegalArgumentException("Cannot provide an instance of " + spanClass.getName() + ", open tracing span is: " + this.delegate.getClass().getName());
    }
}

