/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.tracing.opentracing;

import io.helidon.tracing.Span;
import io.helidon.tracing.SpanContext;
import io.helidon.tracing.opentracing.OpenTracingContext;
import io.helidon.tracing.opentracing.OpenTracingSpan;
import io.opentracing.Tracer;
import io.opentracing.tag.Tags;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

class OpenTracingSpanBuilder
implements Span.Builder<OpenTracingSpanBuilder> {
    private final Tracer.SpanBuilder delegate;
    private final Tracer tracer;
    private Map<String, String> baggage;

    OpenTracingSpanBuilder(Tracer tracer, Tracer.SpanBuilder delegate) {
        this.tracer = tracer;
        this.delegate = delegate;
    }

    public Span build() {
        return new OpenTracingSpan(this.tracer, this.delegate.start());
    }

    public OpenTracingSpanBuilder parent(SpanContext spanContext) {
        if (spanContext instanceof OpenTracingContext) {
            OpenTracingContext otc = (OpenTracingContext)spanContext;
            this.delegate.asChildOf(otc.openTracing());
            if (this.baggage == null) {
                this.baggage = new HashMap<String, String>();
            } else {
                this.baggage.clear();
            }
            otc.openTracing().baggageItems().forEach(entry -> this.baggage.put((String)entry.getKey(), (String)entry.getValue()));
        }
        return this;
    }

    public OpenTracingSpanBuilder kind(Span.Kind kind) {
        String spanKind;
        switch (kind) {
            case SERVER: {
                String string = "server";
                break;
            }
            case CLIENT: {
                String string = "client";
                break;
            }
            case PRODUCER: {
                String string = "producer";
                break;
            }
            case CONSUMER: {
                String string = "consumer";
                break;
            }
            default: {
                String string = spanKind = null;
            }
        }
        if (spanKind != null) {
            this.delegate.withTag(Tags.SPAN_KIND.getKey(), spanKind);
        }
        return this;
    }

    public OpenTracingSpanBuilder tag(String key, String value) {
        this.delegate.withTag(key, value);
        return this;
    }

    public OpenTracingSpanBuilder tag(String key, Boolean value) {
        this.delegate.withTag(key, value.booleanValue());
        return this;
    }

    public OpenTracingSpanBuilder tag(String key, Number value) {
        this.delegate.withTag(key, value);
        return this;
    }

    public Span start(Instant instant) {
        long micro = TimeUnit.MILLISECONDS.toMicros(instant.toEpochMilli());
        OpenTracingSpan result = new OpenTracingSpan(this.tracer, this.delegate.withStartTimestamp(micro).start());
        if (this.baggage != null) {
            this.baggage.forEach((arg_0, arg_1) -> ((Span)result).baggage(arg_0, arg_1));
        }
        return result;
    }
}

