/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

public interface Http2Configuration {
    public static final int DEFAULT_MAX_CONTENT_LENGTH = 65536;

    public boolean enable();

    public int maxContentLength();

    public static final class Builder
    implements io.helidon.common.Builder<Http2Configuration> {
        private boolean enableHttp2 = false;
        private int http2MaxContentLength = 65536;

        public Builder enable(boolean enableHttp2) {
            this.enableHttp2 = enableHttp2;
            return this;
        }

        public Builder maxContentLength(int http2MaxContentLength) {
            this.http2MaxContentLength = http2MaxContentLength;
            return this;
        }

        public Http2Configuration build() {
            return new Http2Configuration(){

                @Override
                public boolean enable() {
                    return enableHttp2;
                }

                @Override
                public int maxContentLength() {
                    return http2MaxContentLength;
                }
            };
        }
    }
}

