/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.common.http.Http;
import io.helidon.webserver.ContentTypeSelector;
import io.helidon.webserver.HttpException;
import io.helidon.webserver.ServerRequest;
import io.helidon.webserver.ServerResponse;
import io.helidon.webserver.StaticContentHandler;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Instant;

class FileSystemContentHandler
extends StaticContentHandler {
    FileSystemContentHandler(String welcomeFilename, ContentTypeSelector contentTypeSelector, Path root) {
        super(welcomeFilename, contentTypeSelector, root);
    }

    @Override
    boolean doHandle(Http.RequestMethod method, Path path, ServerRequest request, ServerResponse response) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            return false;
        }
        if (Files.isDirectory(path, new LinkOption[0])) {
            String rawFullPath = request.uri().getRawPath();
            if (rawFullPath.endsWith("/")) {
                path = this.findWelcomeFile(path);
            } else {
                FileSystemContentHandler.redirect(response, rawFullPath + "/");
                return true;
            }
        }
        if (!Files.isRegularFile(path, new LinkOption[0]) || !Files.isReadable(path) || Files.isHidden(path)) {
            throw new HttpException("File is not accessible", (Http.ResponseStatus)Http.Status.FORBIDDEN_403);
        }
        try {
            Instant lastMod = Files.getLastModifiedTime(path, new LinkOption[0]).toInstant();
            FileSystemContentHandler.processEtag(String.valueOf(lastMod.toEpochMilli()), request.headers(), response.headers());
            FileSystemContentHandler.processModifyHeaders(lastMod, request.headers(), response.headers());
        }
        catch (IOException | SecurityException exception) {
            // empty catch block
        }
        this.processContentType(path, request.headers(), response.headers());
        if (method == Http.Method.HEAD) {
            response.send();
        } else {
            response.send(path);
        }
        return true;
    }

    private Path findWelcomeFile(Path directory) {
        String name = this.welcomePageName();
        FileSystemContentHandler.throwNotFoundIf(name == null || name.isEmpty());
        Path result = directory.resolve(name);
        FileSystemContentHandler.throwNotFoundIf(!Files.exists(result, new LinkOption[0]));
        return result;
    }
}

