/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.webserver.ExperimentalConfiguration;
import io.helidon.webserver.ServerConfiguration;
import io.helidon.webserver.SocketConfiguration;
import io.opentracing.Tracer;
import io.opentracing.util.GlobalTracer;
import java.net.InetAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLContext;

class ServerBasicConfig
implements ServerConfiguration {
    static final ServerConfiguration DEFAULT_CONFIGURATION = ServerConfiguration.builder().build();
    private final SocketConfiguration socketConfig;
    private final int workers;
    private final Tracer tracer;
    private final Map<String, SocketConfiguration> socketConfigs;
    private final ExperimentalConfiguration experimental;

    ServerBasicConfig(SocketConfiguration socketConfig, int workers, Tracer tracer, Map<String, SocketConfiguration> socketConfigs, ExperimentalConfiguration experimental) {
        SocketConfiguration socketConfiguration = this.socketConfig = socketConfig == null ? new SocketConfig() : socketConfig;
        if (workers <= 0) {
            workers = Runtime.getRuntime().availableProcessors() * 2;
        }
        this.workers = workers;
        this.tracer = tracer == null ? GlobalTracer.get() : tracer;
        HashMap<String, SocketConfiguration> map = new HashMap<String, SocketConfiguration>(socketConfigs);
        map.put("@default", this.socketConfig);
        this.socketConfigs = Collections.unmodifiableMap(map);
        this.experimental = experimental != null ? experimental : new ExperimentalConfiguration.Builder().build();
    }

    @Override
    public SSLContext ssl() {
        return this.socketConfig.ssl();
    }

    @Override
    public Set<String> enabledSslProtocols() {
        return this.socketConfig.enabledSslProtocols();
    }

    @Override
    public int workersCount() {
        return this.workers;
    }

    @Override
    public int port() {
        return this.socketConfig.port();
    }

    @Override
    public InetAddress bindAddress() {
        return this.socketConfig.bindAddress();
    }

    @Override
    public int backlog() {
        return this.socketConfig.backlog();
    }

    @Override
    public int timeoutMillis() {
        return this.socketConfig.timeoutMillis();
    }

    @Override
    public int receiveBufferSize() {
        return this.socketConfig.receiveBufferSize();
    }

    @Override
    public Tracer tracer() {
        return this.tracer;
    }

    @Override
    public Map<String, SocketConfiguration> sockets() {
        return this.socketConfigs;
    }

    @Override
    public ExperimentalConfiguration experimental() {
        return this.experimental;
    }

    static class SocketConfig
    implements SocketConfiguration {
        private final int port;
        private final InetAddress bindAddress;
        private final int backlog;
        private final int timeoutMillis;
        private final int receiveBufferSize;
        private final SSLContext sslContext;
        private final Set<String> enabledSslProtocols;

        SocketConfig(int port, InetAddress bindAddress, SSLContext sslContext, Set<String> sslProtocols, int backlog, int timeoutMillis, int receiveBufferSize) {
            this.port = port <= 0 ? 0 : port;
            this.bindAddress = bindAddress;
            this.backlog = backlog <= 0 ? 1024 : backlog;
            this.timeoutMillis = timeoutMillis <= 0 ? 0 : timeoutMillis;
            this.receiveBufferSize = receiveBufferSize <= 0 ? 0 : receiveBufferSize;
            this.sslContext = sslContext;
            this.enabledSslProtocols = sslProtocols;
        }

        SocketConfig() {
            this(0, null, null, null, 0, 0, 0);
        }

        @Override
        public int port() {
            return this.port;
        }

        @Override
        public InetAddress bindAddress() {
            return this.bindAddress;
        }

        @Override
        public int backlog() {
            return this.backlog;
        }

        @Override
        public int timeoutMillis() {
            return this.timeoutMillis;
        }

        @Override
        public int receiveBufferSize() {
            return this.receiveBufferSize;
        }

        @Override
        public SSLContext ssl() {
            return this.sslContext;
        }

        @Override
        public Set<String> enabledSslProtocols() {
            return this.enabledSslProtocols;
        }
    }
}

