/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.common.OptionalHelper;
import io.helidon.common.http.AlreadyCompletedException;
import io.helidon.common.http.Http;
import io.helidon.common.http.MediaType;
import io.helidon.common.http.Parameters;
import io.helidon.common.http.SetCookie;
import io.helidon.common.http.Utils;
import io.helidon.webserver.BareResponse;
import io.helidon.webserver.HashParameters;
import io.helidon.webserver.ResponseHeaders;
import java.net.URI;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

class HashResponseHeaders
extends HashParameters
implements ResponseHeaders {
    private static final String COMPLETED_EXCEPTION_MESSAGE = "Response headers are already completed (sent to the client)!";
    private volatile Http.ResponseStatus httpStatus = Http.Status.OK_200;
    private final CompletionSupport completable;
    private final CompletableFuture<ResponseHeaders> completionStage = new CompletableFuture();

    HashResponseHeaders(BareResponse bareResponse) {
        this.completable = new CompletionSupport(bareResponse);
        if (bareResponse != null) {
            bareResponse.whenHeadersCompleted().thenRun(() -> this.completionStage.complete(this)).exceptionally(thr -> {
                this.completionStage.completeExceptionally((Throwable)thr);
                return null;
            });
        }
        this.put("Date", ZonedDateTime.now().format(Http.DateTime.RFC_1123_DATE_TIME));
    }

    @Override
    public List<MediaType> acceptPatches() {
        List result = this.all("Accept-Patch").stream().flatMap(h -> Utils.tokenize((char)',', (String)"\"", (boolean)false, (String)h).stream()).map(String::trim).map(MediaType::parse).collect(Collectors.toList());
        return Collections.unmodifiableList(result);
    }

    @Override
    public void addAcceptPatches(MediaType ... acceptableMediaTypes) {
        if (acceptableMediaTypes == null) {
            return;
        }
        for (MediaType mt : acceptableMediaTypes) {
            this.add("Accept-Patch", mt.toString());
        }
    }

    @Override
    public Optional<MediaType> contentType() {
        return this.first("Content-Type").map(MediaType::parse);
    }

    @Override
    public void contentType(MediaType contentType) {
        if (contentType == null) {
            this.remove("Content-Type");
        } else {
            this.put("Content-Type", contentType.toString());
        }
    }

    @Override
    public OptionalLong contentLength() {
        return OptionalHelper.from(this.first("Content-Length")).stream().mapToLong(Long::parseLong).findFirst();
    }

    @Override
    public void contentLength(long contentLength) {
        this.put("Content-Length", String.valueOf(contentLength));
    }

    @Override
    public Optional<ZonedDateTime> expires() {
        return this.first("Expires").map(Http.DateTime::parse);
    }

    @Override
    public void expires(ZonedDateTime dateTime) {
        if (dateTime == null) {
            this.remove("Expires");
        } else {
            this.put("Expires", dateTime.format(Http.DateTime.RFC_1123_DATE_TIME));
        }
    }

    @Override
    public void expires(Instant dateTime) {
        if (dateTime == null) {
            this.remove("Expires");
        } else {
            ZonedDateTime dt = ZonedDateTime.ofInstant(dateTime, ZoneId.systemDefault());
            this.put("Expires", dt.format(Http.DateTime.RFC_1123_DATE_TIME));
        }
    }

    @Override
    public Optional<ZonedDateTime> lastModified() {
        return this.first("Last-Modified").map(Http.DateTime::parse);
    }

    @Override
    public void lastModified(ZonedDateTime dateTime) {
        if (dateTime == null) {
            this.remove("Last-Modified");
        } else {
            this.put("Last-Modified", dateTime.format(Http.DateTime.RFC_1123_DATE_TIME));
        }
    }

    @Override
    public void lastModified(Instant dateTime) {
        if (dateTime == null) {
            this.remove("Last-Modified");
        } else {
            ZonedDateTime dt = ZonedDateTime.ofInstant(dateTime, ZoneId.systemDefault());
            this.put("Last-Modified", dt.format(Http.DateTime.RFC_1123_DATE_TIME));
        }
    }

    @Override
    public Optional<URI> location() {
        return this.first("Location").map(URI::create);
    }

    @Override
    public void location(URI location) {
        if (location == null) {
            this.remove("Location");
        } else {
            this.put("Location", location.toASCIIString());
        }
    }

    @Override
    public void addCookie(String name, String value) {
        this.add("Set-Cookie", SetCookie.create((String)name, (String)value).toString());
    }

    @Override
    public void addCookie(String name, String value, Duration maxAge) {
        this.add("Set-Cookie", SetCookie.builder((String)name, (String)value).maxAge(maxAge).build().toString());
    }

    @Override
    public void addCookie(SetCookie cookie) {
        Objects.requireNonNull(cookie, "Parameter 'cookie' is null!");
        this.add("Set-Cookie", cookie.toString());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HashResponseHeaders)) {
            return false;
        }
        HashResponseHeaders that = (HashResponseHeaders)o;
        if (super.equals(that)) {
            return this.httpStatus.equals(that.httpStatus);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.httpStatus);
    }

    Http.ResponseStatus httpStatus() {
        return this.httpStatus;
    }

    void httpStatus(Http.ResponseStatus httpStatusCode) {
        Objects.requireNonNull(httpStatusCode, "Parameter 'httpStatus' is null!");
        this.completable.runIfNotCompleted(() -> {
            this.httpStatus = httpStatusCode;
        }, "Response status code and headers are already completed (sent to the client)!");
    }

    @Override
    public List<String> put(String key, String ... values) {
        return this.completable.supplyIfNotCompleted(() -> super.put(key, values), COMPLETED_EXCEPTION_MESSAGE);
    }

    @Override
    public List<String> put(String key, Iterable<String> values) {
        return this.completable.supplyIfNotCompleted(() -> super.put(key, values), COMPLETED_EXCEPTION_MESSAGE);
    }

    @Override
    public List<String> putIfAbsent(String key, String ... values) {
        return this.completable.supplyIfNotCompleted(() -> super.putIfAbsent(key, values), COMPLETED_EXCEPTION_MESSAGE);
    }

    @Override
    public List<String> putIfAbsent(String key, Iterable<String> values) {
        return this.completable.supplyIfNotCompleted(() -> super.putIfAbsent(key, values), COMPLETED_EXCEPTION_MESSAGE);
    }

    @Override
    public List<String> computeIfAbsent(String key, Function<String, Iterable<String>> values) {
        return this.completable.supplyIfNotCompleted(() -> super.computeIfAbsent(key, values), COMPLETED_EXCEPTION_MESSAGE);
    }

    @Override
    public List<String> computeSingleIfAbsent(String key, Function<String, String> value) {
        return this.completable.supplyIfNotCompleted(() -> super.computeSingleIfAbsent(key, value), COMPLETED_EXCEPTION_MESSAGE);
    }

    @Override
    public void putAll(Parameters parameters) {
        this.completable.runIfNotCompleted(() -> super.putAll(parameters), COMPLETED_EXCEPTION_MESSAGE);
    }

    @Override
    public void add(String key, String ... values) {
        this.completable.runIfNotCompleted(() -> super.add(key, values), COMPLETED_EXCEPTION_MESSAGE);
    }

    @Override
    public void add(String key, Iterable<String> values) {
        this.completable.runIfNotCompleted(() -> super.add(key, values), COMPLETED_EXCEPTION_MESSAGE);
    }

    @Override
    public void addAll(Parameters parameters) {
        this.completable.runIfNotCompleted(() -> super.addAll(parameters), COMPLETED_EXCEPTION_MESSAGE);
    }

    @Override
    public List<String> remove(String key) {
        return this.completable.supplyIfNotCompleted(() -> super.remove(key), COMPLETED_EXCEPTION_MESSAGE);
    }

    @Override
    public void beforeSend(Consumer<ResponseHeaders> headersConsumer) {
        this.completable.beforeComplete(headersConsumer);
    }

    @Override
    public CompletionStage<ResponseHeaders> whenSend() {
        return this.completionStage;
    }

    @Override
    public CompletionStage<ResponseHeaders> send() {
        this.completable.doComplete(this);
        return this.whenSend();
    }

    boolean sendNow() {
        return this.completable.doComplete(this);
    }

    private static class CompletionSupport {
        private volatile State state = State.OPEN;
        private final List<Consumer<ResponseHeaders>> beforeCompleteConsumers = new ArrayList<Consumer<ResponseHeaders>>();
        private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
        private final BareResponse bareResponse;

        CompletionSupport(BareResponse bareResponse) {
            this.bareResponse = bareResponse;
        }

        void runIfNotCompleted(Runnable runnable, String exceptionMessage) {
            block5: {
                if (this.rwLock.readLock().tryLock()) {
                    try {
                        if (this.state != State.COMPLETED) {
                            runnable.run();
                            break block5;
                        }
                        throw new AlreadyCompletedException(exceptionMessage);
                    }
                    finally {
                        this.rwLock.readLock().unlock();
                    }
                }
                throw new AlreadyCompletedException(exceptionMessage);
            }
        }

        <R> R supplyIfNotCompleted(Supplier<R> supplier, String exceptionMessage) {
            if (this.rwLock.readLock().tryLock()) {
                try {
                    if (this.state != State.COMPLETED) {
                        R r = supplier.get();
                        return r;
                    }
                    throw new AlreadyCompletedException(exceptionMessage);
                }
                finally {
                    this.rwLock.readLock().unlock();
                }
            }
            throw new AlreadyCompletedException(exceptionMessage);
        }

        synchronized void beforeComplete(Consumer<ResponseHeaders> consumer) {
            if (this.state != State.OPEN) {
                throw new AlreadyCompletedException("Cannot accept new 'beforeComplete consumer'! Headers are sent.");
            }
            this.beforeCompleteConsumers.add(consumer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized boolean doComplete(HashResponseHeaders headers) {
            if (this.state != State.OPEN) {
                return false;
            }
            this.state = State.COMPLETING;
            try {
                for (Consumer<ResponseHeaders> consumer : this.beforeCompleteConsumers) {
                    consumer.accept(headers);
                }
                this.rwLock.writeLock().lock();
                try {
                    this.state = State.COMPLETED;
                    Map<String, List<String>> rawHeaders = this.filterSpecificHeaders(headers.toMap(), headers.httpStatus);
                    this.bareResponse.writeStatusAndHeaders(headers.httpStatus, rawHeaders);
                }
                finally {
                    this.rwLock.writeLock().unlock();
                }
            }
            catch (Throwable th) {
                this.bareResponse.onError(th);
            }
            return true;
        }

        private Map<String, List<String>> filterSpecificHeaders(Map<String, List<String>> data, Http.ResponseStatus status) {
            if (data == null) {
                return null;
            }
            if (status.code() == Http.Status.NO_CONTENT_204.code()) {
                data.remove("Transfer-Encoding");
                data.remove("Content-Disposition");
                data.remove("Content-Encoding");
                data.remove("Content-Language");
                data.remove("Content-Length");
                data.remove("aa");
                data.remove("Content-Range");
                data.remove("Content-Type");
            }
            return data;
        }

        private static enum State {
            OPEN,
            COMPLETING,
            COMPLETED;

        }
    }
}

