/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.common.CollectionsHelper;
import io.helidon.common.context.Context;
import io.helidon.common.context.Contexts;
import io.helidon.common.http.AlreadyCompletedException;
import io.helidon.common.http.Http;
import io.helidon.common.http.HttpRequest;
import io.helidon.tracing.config.SpanTracingConfig;
import io.helidon.tracing.config.TracingConfigUtil;
import io.helidon.webserver.BareRequest;
import io.helidon.webserver.BareResponse;
import io.helidon.webserver.ErrorHandler;
import io.helidon.webserver.HandlerRoute;
import io.helidon.webserver.HttpException;
import io.helidon.webserver.NotFoundException;
import io.helidon.webserver.PathMatcher;
import io.helidon.webserver.Request;
import io.helidon.webserver.Response;
import io.helidon.webserver.Route;
import io.helidon.webserver.RouteList;
import io.helidon.webserver.Routing;
import io.helidon.webserver.ServerRequest;
import io.helidon.webserver.WebServer;
import io.helidon.webserver.WebTracingConfig;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;

class RequestRouting
implements Routing {
    private static final Logger LOGGER = Logger.getLogger(RequestRouting.class.getName());
    private final RouteList routes;
    private final List<ErrorHandlerRecord<?>> errorHandlers;
    private final List<Consumer<WebServer>> newWebServerCallbacks;

    RequestRouting(RouteList routes, List<ErrorHandlerRecord<?>> errorHandlers, List<Consumer<WebServer>> newWebServerCallbacks) {
        this.routes = routes;
        this.errorHandlers = errorHandlers;
        this.newWebServerCallbacks = new ArrayList<Consumer<WebServer>>(newWebServerCallbacks);
    }

    @Override
    public void route(BareRequest bareRequest, BareResponse bareResponse) {
        try {
            WebServer webServer = bareRequest.webServer();
            RoutedResponse response = new RoutedResponse(webServer, bareResponse);
            String path = RequestRouting.canonicalize(bareRequest.uri().normalize().getPath());
            String rawPath = RequestRouting.canonicalize(bareRequest.uri().normalize().getRawPath());
            Crawler crawler = new Crawler(this.routes, path, rawPath, bareRequest.method());
            RoutedRequest nextRequests = new RoutedRequest(bareRequest, response, webServer, crawler, this.errorHandlers);
            Contexts.runInContext((Context)nextRequests.context(), nextRequests::next);
        }
        catch (Error | RuntimeException e) {
            LOGGER.log(Level.SEVERE, "Unexpected error occurred during routing!", e);
            throw e;
        }
    }

    private static String canonicalize(String p) {
        String result = p;
        if (p.charAt(p.length() - 1) == '/') {
            result = p.substring(0, p.length() - 1);
        }
        if (result.isEmpty()) {
            result = "/";
        }
        return result;
    }

    void fireNewWebServer(WebServer webServer) {
        for (Consumer<WebServer> callback : this.newWebServerCallbacks) {
            callback.accept(webServer);
        }
    }

    static class ErrorHandlerRecord<T extends Throwable> {
        private final Class<T> exceptionClass;
        private final ErrorHandler<T> errorHandler;

        private ErrorHandlerRecord(Class<T> exceptionClass, ErrorHandler<T> errorHandler) {
            this.exceptionClass = exceptionClass;
            this.errorHandler = errorHandler;
        }

        public static <T extends Throwable> ErrorHandlerRecord<T> of(Class<T> exceptionClass, ErrorHandler<T> errorHandler) {
            return new ErrorHandlerRecord<T>(exceptionClass, errorHandler);
        }
    }

    private static class RoutedResponse
    extends Response {
        RoutedResponse(WebServer webServer, BareResponse bareResponse) {
            super(webServer, bareResponse);
        }

        RoutedResponse(RoutedResponse response) {
            super(response);
        }

        @Override
        Optional<SpanContext> spanContext() {
            return Contexts.context().flatMap(ctx -> ctx.get(SpanContext.class));
        }
    }

    private static class RoutedRequest
    extends Request {
        private final Crawler crawler;
        private final LinkedList<ErrorHandlerRecord<? extends Throwable>> errorHandlers;
        private final Request.Path path;
        private final RoutedResponse response;
        private final AtomicBoolean nexted = new AtomicBoolean(false);

        RoutedRequest(BareRequest req, RoutedResponse response, WebServer webServer, Crawler crawler, List<ErrorHandlerRecord<?>> errorHandlers) {
            super(req, webServer);
            this.crawler = crawler;
            this.errorHandlers = new LinkedList(errorHandlers);
            this.path = null;
            this.response = response;
        }

        RoutedRequest(RoutedRequest request, RoutedResponse response, Request.Path path, List<ErrorHandlerRecord<?>> errorHandlers) {
            super(request);
            this.crawler = request.crawler;
            this.response = response;
            this.path = path;
            this.errorHandlers = new LinkedList(errorHandlers);
        }

        @Override
        public Span span() {
            return this.context().get(ServerRequest.class, Span.class).orElse(null);
        }

        @Override
        public SpanContext spanContext() {
            return this.context().get(ServerRequest.class, SpanContext.class).orElse(null);
        }

        boolean nexted() {
            return this.nexted.get();
        }

        @Override
        public void next() {
            this.checkNexted();
            Crawler.Item nextItem = this.crawler.next();
            if (nextItem == null) {
                this.nextNoCheck(new NotFoundException("No handler found for path: " + this.path()));
            } else {
                try {
                    SpanTracingConfig spanConfig;
                    RoutedResponse nextResponse = new RoutedResponse(this.response);
                    RoutedRequest nextRequest = new RoutedRequest(this, nextResponse, nextItem.path, this.errorHandlers);
                    LOGGER.finest(() -> "(reqID: " + this.requestId() + ") Routing next: " + nextItem.path);
                    Span span = this.span();
                    if (null != span && (spanConfig = TracingConfigUtil.spanConfig((String)"web-server", (String)"HTTP Request")).spanLog("handler.class").enabled()) {
                        span.log(nextItem.handlerRoute.diagnosticEvent());
                    }
                    nextItem.handlerRoute.handler().accept(nextRequest, nextResponse);
                }
                catch (RuntimeException re) {
                    this.nextNoCheck(re);
                }
            }
        }

        private void checkNexted() {
            this.checkNexted(null);
        }

        private void checkNexted(Throwable t) {
            if (!this.nexted.compareAndSet(false, true)) {
                throw new IllegalStateException("The 'next()' method can be called only once!", t);
            }
        }

        private void nextNoCheck(Throwable t) {
            LOGGER.finest(() -> "(reqID: " + this.requestId() + ") Routing error: " + t.getClass());
            ErrorHandlerRecord<? extends Throwable> record = this.errorHandlers.pollFirst();
            while (record != null) {
                if (((ErrorHandlerRecord)record).exceptionClass.isAssignableFrom(t.getClass())) {
                    ErrorRoutedRequest nextErrorRequest = new ErrorRoutedRequest(this.errorHandlers, t);
                    Span span = this.span();
                    if (null != span) {
                        span.log(CollectionsHelper.mapOf((Object)"event", (Object)"error-handler", (Object)"handler.class", (Object)((ErrorHandlerRecord)record).errorHandler.getClass().getName(), (Object)"handled.error.message", (Object)t.toString()));
                    }
                    try {
                        ((ErrorHandlerRecord)record).errorHandler.accept(nextErrorRequest, this.response, t);
                    }
                    catch (Throwable e) {
                        LOGGER.log(Level.WARNING, "Exception unexpectedly thrown from an error handler. Error handling of this logged exception was aborted.", t);
                        this.defaultHandler(new IllegalStateException("Unexpected exception encountered during error handling.", e));
                        return;
                    }
                    return;
                }
                record = this.errorHandlers.pollFirst();
            }
            this.defaultHandler(t);
        }

        private void defaultHandler(Throwable t) {
            Span span = this.span();
            if (null != span) {
                span.log(CollectionsHelper.mapOf((Object)"event", (Object)"error-handler", (Object)"handler.class", (Object)"DEFAULT-ERROR-HANDLER", (Object)"handled.error.message", (Object)t.toString()));
            }
            try {
                if (t instanceof HttpException) {
                    this.response.status(((HttpException)t).status());
                } else if (t.getCause() instanceof HttpException) {
                    this.response.status(((HttpException)t.getCause()).status());
                } else if (t instanceof RejectedExecutionException || t.getCause() instanceof RejectedExecutionException) {
                    this.response.status((Http.ResponseStatus)Http.Status.SERVICE_UNAVAILABLE_503);
                } else {
                    LOGGER.log(t instanceof Error ? Level.SEVERE : Level.WARNING, "Default error handler: Unhandled exception encountered.", new ExecutionException("Unhandled 'cause' of this exception encountered.", t));
                    this.response.status((Http.ResponseStatus)Http.Status.INTERNAL_SERVER_ERROR_500);
                }
            }
            catch (AlreadyCompletedException e) {
                LOGGER.log(Level.WARNING, "Cannot perform error handling of the throwable (see cause of this exception) because headers were already sent", new IllegalStateException("Headers already sent. Cannot handle the cause of this exception.", t));
            }
            this.response.send().exceptionally(throwable -> {
                LOGGER.log(Level.WARNING, "Default error handler: Response wasn't successfully sent.", (Throwable)throwable);
                return null;
            });
        }

        @Override
        public void next(Throwable t) {
            this.checkNexted();
            this.nextNoCheck(t);
        }

        public HttpRequest.Path path() {
            return this.path;
        }

        @Override
        public Tracer tracer() {
            return WebTracingConfig.tracer(this.webServer());
        }

        private class ErrorRoutedRequest
        extends RoutedRequest {
            private final Throwable t;

            ErrorRoutedRequest(LinkedList<ErrorHandlerRecord<?>> errorHandlers, Throwable t) {
                super(RoutedRequest.this, new RoutedResponse(RoutedRequest.this.response), RoutedRequest.this.path, errorHandlers);
                this.t = t;
            }

            @Override
            public void next() {
                super.next(this.t);
            }

            @Override
            public HttpRequest.Path path() {
                return super.path().absolute();
            }
        }
    }

    private static class Crawler {
        private final List<Route> routes;
        private final Request.Path contextPath;
        private final String path;
        private final String rawPath;
        private final Http.RequestMethod method;
        private volatile int index = -1;
        private volatile Crawler subCrawler;

        private Crawler(List<Route> routes, Request.Path contextPath, String path, String rawPath, Http.RequestMethod method) {
            this.routes = routes;
            this.path = path;
            this.rawPath = rawPath;
            this.contextPath = contextPath;
            this.method = method;
        }

        Crawler(List<Route> routes, String path, String rawPath, Http.RequestMethod method) {
            this(routes, null, path, rawPath, method);
        }

        public Item next() {
            while (this.subCrawler != null || ++this.index < this.routes.size()) {
                if (this.subCrawler != null) {
                    Item result = this.subCrawler.next();
                    if (result != null) {
                        return result;
                    }
                    this.subCrawler = null;
                    continue;
                }
                Route route = this.routes.get(this.index);
                if (route.accepts(this.method)) {
                    if (route instanceof HandlerRoute) {
                        HandlerRoute hr = (HandlerRoute)route;
                        PathMatcher.Result match = hr.match(this.path);
                        if (match.matches()) {
                            return new Item(hr, Request.Path.create(this.contextPath, this.path, this.rawPath, match.params()));
                        }
                    } else if (route instanceof RouteList) {
                        RouteList rl = (RouteList)route;
                        PathMatcher.PrefixResult prefixMatch = rl.prefixMatch(this.path);
                        PathMatcher.PrefixResult rawPrefixMatch = rl.prefixMatch(this.rawPath);
                        if (prefixMatch.matches()) {
                            this.subCrawler = new Crawler(rl, Request.Path.create(this.contextPath, this.path, this.rawPath, prefixMatch.params()), prefixMatch.remainingPart(), rawPrefixMatch.remainingPart(), this.method);
                            continue;
                        }
                    }
                    LOGGER.finest(() -> "Route candidate '" + route + "' doesn't match path: " + this.path);
                    continue;
                }
                LOGGER.finest(() -> "Route candidate '" + route + "' doesn't match method: " + this.method);
            }
            return null;
        }

        private static class Item {
            private final HandlerRoute handlerRoute;
            private final Request.Path path;

            Item(HandlerRoute handlerRoute, Request.Path path) {
                this.handlerRoute = handlerRoute;
                this.path = path;
            }
        }
    }
}

