/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.common.http.Http;
import io.helidon.common.http.MediaType;
import io.helidon.webserver.ContentTypeSelector;
import io.helidon.webserver.HttpException;
import io.helidon.webserver.RequestHeaders;
import io.helidon.webserver.ResponseHeaders;
import io.helidon.webserver.ServerRequest;
import io.helidon.webserver.ServerResponse;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.time.chrono.ChronoZonedDateTime;
import java.util.List;
import java.util.Optional;

abstract class StaticContentHandler {
    private final String welcomeFilename;
    private final ContentTypeSelector contentTypeSelector;
    private final Path root;

    StaticContentHandler(String welcomeFilename, ContentTypeSelector contentTypeSelector, Path root) {
        this.welcomeFilename = welcomeFilename;
        this.contentTypeSelector = contentTypeSelector;
        this.root = root;
    }

    void releaseCache() {
    }

    void handle(Http.RequestMethod method, ServerRequest request, ServerResponse response) {
        Path resolved;
        if (method != Http.Method.GET && method != Http.Method.HEAD) {
            request.next();
            return;
        }
        String requestPath = request.path().toString();
        if (requestPath.startsWith("/")) {
            requestPath = requestPath.substring(1);
        }
        if (requestPath.isEmpty()) {
            resolved = this.root;
        } else {
            resolved = this.root.resolve(Paths.get(requestPath, new String[0])).normalize();
            if (!resolved.startsWith(this.root)) {
                request.next();
                return;
            }
        }
        try {
            if (!this.doHandle(method, resolved, request, response)) {
                request.next();
            }
        }
        catch (IOException e) {
            throw new HttpException("Cannot access static resource!", (Http.ResponseStatus)Http.Status.INTERNAL_SERVER_ERROR_500, e);
        }
        catch (HttpException httpException) {
            if (httpException.status().code() == Http.Status.NOT_FOUND_404.code()) {
                request.next();
            }
            throw httpException;
        }
    }

    abstract boolean doHandle(Http.RequestMethod var1, Path var2, ServerRequest var3, ServerResponse var4) throws IOException;

    static void processEtag(String etag, RequestHeaders requestHeaders, ResponseHeaders responseHeaders) {
        if (etag == null || etag.isEmpty()) {
            return;
        }
        etag = StaticContentHandler.unquoteETag(etag);
        responseHeaders.put("ETag", new String[]{'\"' + etag + '\"'});
        List ifNoneMatches = requestHeaders.values("If-None-Match");
        for (String ifNoneMatch : ifNoneMatches) {
            if (!"*".equals(ifNoneMatch = StaticContentHandler.unquoteETag(ifNoneMatch)) && !ifNoneMatch.equals(etag)) continue;
            throw new HttpException("Accepted by If-None-Match header!", (Http.ResponseStatus)Http.Status.NOT_MODIFIED_304);
        }
        List ifMatches = requestHeaders.values("If-Match");
        if (!ifMatches.isEmpty()) {
            boolean ifMatchChecked = false;
            for (String ifMatch : ifMatches) {
                if (!"*".equals(ifMatch = StaticContentHandler.unquoteETag(ifMatch)) && !ifMatch.equals(etag)) continue;
                ifMatchChecked = true;
                break;
            }
            if (!ifMatchChecked) {
                throw new HttpException("Not accepted by If-Match header!", (Http.ResponseStatus)Http.Status.PRECONDITION_FAILED_412);
            }
        }
    }

    private static String unquoteETag(String etag) {
        if (etag == null || etag.isEmpty()) {
            return etag;
        }
        if (etag.startsWith("W/") || etag.startsWith("w/")) {
            etag = etag.substring(2);
        }
        if (etag.startsWith("\"") && etag.endsWith("\"")) {
            etag = etag.substring(1, etag.length() - 1);
        }
        return etag;
    }

    static void processModifyHeaders(Instant modified, RequestHeaders requestHeaders, ResponseHeaders responseHeaders) {
        if (modified == null) {
            return;
        }
        responseHeaders.lastModified(modified);
        Optional<Instant> ifModSince = requestHeaders.ifModifiedSince().map(ChronoZonedDateTime::toInstant);
        if (ifModSince.isPresent() && !ifModSince.get().isBefore(modified)) {
            throw new HttpException("Not valid for If-Modified-Since header!", (Http.ResponseStatus)Http.Status.NOT_MODIFIED_304);
        }
        Optional<Instant> ifUnmodSince = requestHeaders.ifUnmodifiedSince().map(ChronoZonedDateTime::toInstant);
        if (ifUnmodSince.isPresent() && ifUnmodSince.get().isBefore(modified)) {
            throw new HttpException("Not valid for If-Unmodified-Since header!", (Http.ResponseStatus)Http.Status.PRECONDITION_FAILED_412);
        }
    }

    static void throwNotFoundIf(boolean condition) {
        if (condition) {
            throw new HttpException("Content not found!", (Http.ResponseStatus)Http.Status.NOT_FOUND_404);
        }
    }

    static void redirect(ServerResponse response, String location) {
        response.status((Http.ResponseStatus)Http.Status.MOVED_PERMANENTLY_301);
        response.headers().put("Location", new String[]{location});
        response.send();
    }

    String welcomePageName() {
        return this.welcomeFilename;
    }

    void processContentType(Path path, RequestHeaders requestHeaders, ResponseHeaders responseHeaders) {
        this.processContentType(StaticContentHandler.fileName(path), requestHeaders, responseHeaders);
    }

    void processContentType(String filename, RequestHeaders requestHeaders, ResponseHeaders responseHeaders) {
        MediaType type = this.contentTypeSelector.determine(filename, requestHeaders);
        if (type != null) {
            responseHeaders.contentType(type);
        }
    }

    static String fileName(Path path) {
        Path fileName = path.getFileName();
        if (null == fileName) {
            return "";
        }
        return fileName.toString();
    }
}

