/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.common.Builder;
import io.helidon.common.CollectionsHelper;
import io.helidon.common.pki.KeyConfig;
import io.helidon.config.Config;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStore;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.TrustManagerFactory;

public final class SSLContextBuilder
implements Builder<SSLContext> {
    private static final String PROTOCOL = "TLS";
    private static final Random RANDOM = new Random();
    private KeyConfig privateKeyConfig;
    private KeyConfig trustConfig;
    private long sessionCacheSize;
    private long sessionTimeout;

    private SSLContextBuilder() {
    }

    public static SSLContextBuilder create(KeyConfig privateKeyConfig) {
        return new SSLContextBuilder().privateKeyConfig(privateKeyConfig);
    }

    public static SSLContext create(Config sslConfig) {
        return new SSLContextBuilder().privateKeyConfig(KeyConfig.create((Config)sslConfig.get("private-key"))).sessionCacheSize(((Integer)sslConfig.get("session-cache-size").asInt().orElse((Object)0)).intValue()).sessionTimeout(((Integer)sslConfig.get("session-timeout").asInt().orElse((Object)0)).intValue()).trustConfig(KeyConfig.create((Config)sslConfig.get("trust"))).build();
    }

    private SSLContextBuilder privateKeyConfig(KeyConfig privateKeyConfig) {
        this.privateKeyConfig = privateKeyConfig;
        return this;
    }

    public SSLContextBuilder trustConfig(KeyConfig trustConfig) {
        this.trustConfig = trustConfig;
        return this;
    }

    public SSLContextBuilder sessionCacheSize(long sessionCacheSize) {
        this.sessionCacheSize = sessionCacheSize;
        return this;
    }

    public SSLContextBuilder sessionTimeout(long sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
        return this;
    }

    public SSLContext build() {
        Objects.requireNonNull(this.privateKeyConfig, "The private key config must be set!");
        try {
            return SSLContextBuilder.newSSLContext(this.privateKeyConfig, this.trustConfig, this.sessionCacheSize, this.sessionTimeout);
        }
        catch (IOException | GeneralSecurityException e) {
            throw new IllegalStateException("Building of the SSLContext of unsuccessful!", e);
        }
    }

    private static SSLContext newSSLContext(KeyConfig privateKeyConfig, KeyConfig trustConfig, long sessionCacheSize, long sessionTimeout) throws IOException, GeneralSecurityException {
        KeyManagerFactory kmf = SSLContextBuilder.buildKmf(privateKeyConfig);
        TrustManagerFactory tmf = SSLContextBuilder.buildTmf(trustConfig);
        SSLContext ctx = SSLContext.getInstance(PROTOCOL);
        ctx.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
        SSLSessionContext sessCtx = ctx.getServerSessionContext();
        if (sessionCacheSize > 0L) {
            sessCtx.setSessionCacheSize((int)Math.min(sessionCacheSize, Integer.MAX_VALUE));
        }
        if (sessionTimeout > 0L) {
            sessCtx.setSessionTimeout((int)Math.min(sessionTimeout, Integer.MAX_VALUE));
        }
        return ctx;
    }

    private static KeyManagerFactory buildKmf(KeyConfig privateKeyConfig) throws IOException, GeneralSecurityException {
        String algorithm = Security.getProperty("ssl.KeyManagerFactory.algorithm");
        if (algorithm == null) {
            algorithm = "SunX509";
        }
        byte[] passwordBytes = new byte[64];
        RANDOM.nextBytes(passwordBytes);
        char[] password = Base64.getEncoder().encodeToString(passwordBytes).toCharArray();
        KeyStore ks = KeyStore.getInstance("JKS");
        ks.load(null, null);
        ks.setKeyEntry("key", (Key)privateKeyConfig.privateKey().orElseThrow(() -> new RuntimeException("Private key not available")), password, privateKeyConfig.certChain().toArray(new Certificate[0]));
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(algorithm);
        kmf.init(ks, password);
        return kmf;
    }

    private static TrustManagerFactory buildTmf(KeyConfig trustConfig) throws IOException, GeneralSecurityException {
        List certs = trustConfig == null ? CollectionsHelper.listOf() : trustConfig.certs();
        KeyStore ks = KeyStore.getInstance("JKS");
        ks.load(null, null);
        int i = 1;
        for (X509Certificate cert : certs) {
            ks.setCertificateEntry(String.valueOf(i), cert);
            ++i;
        }
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(ks);
        return tmf;
    }
}

