/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.webserver.ServerResponseSubscription;
import java.util.concurrent.Flow;

public enum BackpressureStrategy {
    LINEAR(1),
    AUTO_FLUSH(2),
    PREFETCH(3),
    UNBOUNDED(4);

    private final int type;

    private BackpressureStrategy(int type) {
        this.type = type;
    }

    ServerResponseSubscription createSubscription(Flow.Subscription subscription, long backpressureBufferSize) {
        switch (this.type) {
            case 1: {
                return new ServerResponseSubscription.WatermarkLinear(subscription, backpressureBufferSize);
            }
            case 2: {
                return new ServerResponseSubscription.WatermarkAutoFlush(subscription, backpressureBufferSize);
            }
            case 3: {
                return new ServerResponseSubscription.WatermarkPrefetch(subscription, backpressureBufferSize);
            }
            case 4: {
                return new ServerResponseSubscription.Unbounded(subscription);
            }
        }
        throw new IllegalStateException("Unknown backpressure strategy.");
    }
}

