/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.common.pki.KeyConfig;
import io.helidon.config.Config;
import io.helidon.config.DeprecatedConfig;
import io.helidon.config.metadata.Configured;
import io.helidon.webserver.ClientAuthentication;
import io.helidon.webserver.ConfiguredTlsManager;
import io.helidon.webserver.TlsManager;
import io.helidon.webserver.spi.TlsManagerProvider;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;

public final class WebServerTls {
    private static final String PROTOCOL = "TLS";
    public static final String CLIENT_X509_CERTIFICATE = WebServerTls.class.getName() + ".client-x509-certificate";
    private final TlsManager tlsManager;
    private final Set<String> enabledTlsProtocols;
    private final Set<String> cipherSuite;
    private final SSLContext explicitSslContext;
    private final KeyConfig privateKeyConfig;
    private final KeyConfig trustConfig;
    private final boolean trustAll;
    private final int sessionCacheSize;
    private final int sessionTimeoutSeconds;
    private final boolean enabled;
    private final ClientAuthentication clientAuth;

    private WebServerTls(Builder builder) {
        this.tlsManager = builder.tlsManager;
        this.enabledTlsProtocols = Set.copyOf(builder.enabledTlsProtocols);
        this.cipherSuite = builder.cipherSuite;
        this.explicitSslContext = builder.explicitSslContext;
        this.privateKeyConfig = builder.privateKeyConfig;
        this.trustConfig = builder.trustConfig;
        this.trustAll = builder.trustAll;
        this.sessionCacheSize = (int)builder.sessionCacheSize;
        this.sessionTimeoutSeconds = (int)builder.sessionTimeoutSeconds;
        this.enabled = builder.enabled;
        this.clientAuth = builder.clientAuth;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static WebServerTls create(Config config) {
        return WebServerTls.builder().config(config).build();
    }

    public TlsManager manager() {
        return this.tlsManager;
    }

    public boolean trustAll() {
        return this.trustAll;
    }

    Collection<String> enabledTlsProtocols() {
        return this.enabledTlsProtocols;
    }

    Optional<SSLContext> explicitSslContext() {
        return Optional.ofNullable(this.explicitSslContext);
    }

    SSLContext sslContext() {
        if (this.explicitSslContext != null) {
            return this.explicitSslContext;
        }
        return this.manager().sslContext();
    }

    KeyConfig privateKeyConfig() {
        return this.privateKeyConfig;
    }

    KeyConfig trustConfig() {
        return this.trustConfig;
    }

    String protocol() {
        return PROTOCOL;
    }

    int sessionCacheSize() {
        return this.sessionCacheSize;
    }

    int sessionTimeoutSeconds() {
        return this.sessionTimeoutSeconds;
    }

    ClientAuthentication clientAuth() {
        return this.clientAuth;
    }

    Set<String> cipherSuite() {
        return this.cipherSuite;
    }

    public boolean enabled() {
        return this.enabled;
    }

    @Configured
    public static class Builder
    implements io.helidon.common.Builder<Builder, WebServerTls> {
        private final Set<String> enabledTlsProtocols = new HashSet<String>();
        private TlsManager tlsManager;
        private SSLContext explicitSslContext;
        private KeyConfig privateKeyConfig;
        private KeyConfig trustConfig;
        private long sessionCacheSize;
        private long sessionTimeoutSeconds;
        private boolean trustAll;
        private boolean enabled;
        private Boolean explicitEnabled;
        private ClientAuthentication clientAuth;
        private Set<String> cipherSuite = Set.of();

        private Builder() {
            this.clientAuth = ClientAuthentication.NONE;
        }

        public WebServerTls build() {
            boolean enabled = null == this.explicitEnabled ? this.enabled : this.explicitEnabled;
            if (this.tlsManager == null) {
                this.tlsManager = new ConfiguredTlsManager();
            }
            if (!enabled) {
                this.explicitSslContext = null;
                return new WebServerTls(this);
            }
            WebServerTls tls = new WebServerTls(this);
            this.tlsManager.init(tls);
            return tls;
        }

        public Builder config(Config config) {
            config.get("enabled").asBoolean().ifPresent(this::enabled);
            if (this.explicitEnabled != null && !this.explicitEnabled.booleanValue()) {
                return this;
            }
            config.get("client-auth").asString().ifPresent(this::clientAuth);
            config.get("private-key").ifExists(it -> this.privateKey(KeyConfig.create((Config)it)));
            config.get("trust").ifExists(it -> this.trust(KeyConfig.create((Config)it)));
            config.get("protocols").asList(String.class).ifPresent(this::enabledProtocols);
            config.get("session-cache-size").asLong().ifPresent(this::sessionCacheSize);
            config.get("cipher-suite").asList(String.class).ifPresent(this::allowedCipherSuite);
            DeprecatedConfig.get((Config)config, (String)"session-timeout-seconds", (String)"session-timeout").asLong().ifPresent(this::sessionTimeoutSeconds);
            config.get("manager").ifExists(it -> this.tlsManager(TlsManagerProvider.create(it)));
            config.get("trust-all").asBoolean().ifPresent(this::trustAll);
            return this;
        }

        public Builder tlsManager(TlsManager tlsManager) {
            this.enabled = true;
            this.tlsManager = Objects.requireNonNull(tlsManager);
            return this;
        }

        public Builder trustAll(boolean trustAll) {
            this.trustAll = trustAll;
            return this;
        }

        private void clientAuth(String it) {
            this.clientAuth(ClientAuthentication.valueOf(it.toUpperCase()));
        }

        public Builder clientAuth(ClientAuthentication clientAuth) {
            this.clientAuth = Objects.requireNonNull(clientAuth);
            return this;
        }

        public Builder sslContext(SSLContext context) {
            this.enabled = true;
            this.explicitSslContext = context;
            return this;
        }

        public Builder enabledProtocols(String ... protocols) {
            return this.enabledProtocols(Arrays.asList(Objects.requireNonNull(protocols)));
        }

        public Builder enabledProtocols(Collection<String> protocols) {
            Objects.requireNonNull(protocols);
            this.enabledTlsProtocols.clear();
            this.enabledTlsProtocols.addAll(protocols);
            return this;
        }

        public Builder privateKey(KeyConfig privateKeyConfig) {
            this.enabled = true;
            this.explicitSslContext = null;
            this.privateKeyConfig = Objects.requireNonNull(privateKeyConfig);
            return this;
        }

        public Builder privateKey(Supplier<KeyConfig> privateKeyConfigBuilder) {
            return this.privateKey(privateKeyConfigBuilder.get());
        }

        public Builder trust(KeyConfig trustConfig) {
            this.enabled = true;
            this.explicitSslContext = null;
            this.trustConfig = Objects.requireNonNull(trustConfig);
            return this;
        }

        public Builder trust(Supplier<KeyConfig> trustConfigBuilder) {
            return this.trust(trustConfigBuilder.get());
        }

        public Builder sessionCacheSize(long sessionCacheSize) {
            this.sessionCacheSize = sessionCacheSize;
            return this;
        }

        public Builder sessionTimeoutSeconds(long sessionTimeout) {
            this.sessionTimeoutSeconds = sessionTimeout;
            return this;
        }

        public Builder sessionTimeout(long timeout, TimeUnit unit) {
            this.sessionTimeoutSeconds = unit.toSeconds(timeout);
            return this;
        }

        public Builder allowedCipherSuite(List<String> cipherSuite) {
            Objects.requireNonNull(cipherSuite);
            if (cipherSuite.isEmpty()) {
                throw new IllegalStateException("Allowed cipher suite has to have at least one cipher specified");
            }
            this.cipherSuite = Set.copyOf(cipherSuite);
            return this;
        }

        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            this.explicitEnabled = enabled;
            return this;
        }
    }
}

