/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.spi;

import io.helidon.common.serviceloader.HelidonServiceLoader;
import io.helidon.config.Config;
import io.helidon.webserver.TlsManager;
import io.helidon.webserver.spi.TlsManagerCache;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.function.Function;

public interface TlsManagerProvider {
    public String configKey();

    public TlsManager create(Config var1, String var2);

    public static <T> TlsManager getOrCreate(T configBean, Function<T, TlsManager> creator) {
        return TlsManagerCache.getOrCreate(configBean, creator);
    }

    public static TlsManager create(Config config) {
        List namedManagers = (List)config.asNodeList().orElse(List.of());
        if (namedManagers.size() != 1) {
            throw new IllegalStateException("Expected to have one manager defined for config: '" + config.name() + "'; but instead found: " + namedManagers.size());
        }
        String theConfigKey = ((Config)namedManagers.get(0)).key().name();
        Map<String, TlsManagerProvider> providerMap = TlsManagerProvider.availableProviders();
        TlsManagerProvider provider = providerMap.get(theConfigKey);
        if (provider == null) {
            throw new IllegalStateException("Expected to find a provider named '" + theConfigKey + "' but did not find it in: " + providerMap.keySet());
        }
        return provider.create(config.get(theConfigKey), theConfigKey);
    }

    private static Map<String, TlsManagerProvider> availableProviders() {
        HelidonServiceLoader loader = HelidonServiceLoader.create(ServiceLoader.load(TlsManagerProvider.class));
        LinkedHashMap<String, TlsManagerProvider> providers = new LinkedHashMap<String, TlsManagerProvider>();
        loader.forEach(provider -> {
            String configKey = provider.configKey();
            if (null != configKey) {
                providers.put(configKey, (TlsManagerProvider)provider);
            }
        });
        return providers;
    }
}

