/*
 * Decompiled with CFR 0.152.
 */
package jaeger.org.apache.http.impl.client;

import jaeger.org.apache.http.HeaderElement;
import jaeger.org.apache.http.HttpResponse;
import jaeger.org.apache.http.annotation.Immutable;
import jaeger.org.apache.http.conn.ConnectionKeepAliveStrategy;
import jaeger.org.apache.http.message.BasicHeaderElementIterator;
import jaeger.org.apache.http.protocol.HttpContext;
import jaeger.org.apache.http.util.Args;

@Immutable
public class DefaultConnectionKeepAliveStrategy
implements ConnectionKeepAliveStrategy {
    public static final DefaultConnectionKeepAliveStrategy INSTANCE = new DefaultConnectionKeepAliveStrategy();

    @Override
    public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
        Args.notNull(response, "HTTP response");
        BasicHeaderElementIterator it = new BasicHeaderElementIterator(response.headerIterator("Keep-Alive"));
        while (it.hasNext()) {
            HeaderElement he = it.nextElement();
            String param = he.getName();
            String value = he.getValue();
            if (value == null || !param.equalsIgnoreCase("timeout")) continue;
            try {
                return Long.parseLong(value) * 1000L;
            }
            catch (NumberFormatException ignore) {
            }
        }
        return -1L;
    }
}

