/*
 * Decompiled with CFR 0.152.
 */
package jaeger.org.apache.http.protocol;

import jaeger.org.apache.http.HttpEntity;
import jaeger.org.apache.http.HttpEntityEnclosingRequest;
import jaeger.org.apache.http.HttpException;
import jaeger.org.apache.http.HttpRequest;
import jaeger.org.apache.http.HttpRequestInterceptor;
import jaeger.org.apache.http.HttpVersion;
import jaeger.org.apache.http.ProtocolVersion;
import jaeger.org.apache.http.annotation.Immutable;
import jaeger.org.apache.http.protocol.HttpContext;
import jaeger.org.apache.http.util.Args;
import java.io.IOException;

@Immutable
public class RequestExpectContinue
implements HttpRequestInterceptor {
    private final boolean activeByDefault;

    @Deprecated
    public RequestExpectContinue() {
        this(false);
    }

    public RequestExpectContinue(boolean activeByDefault) {
        this.activeByDefault = activeByDefault;
    }

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("Expect") && request instanceof HttpEntityEnclosingRequest) {
            boolean active;
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            if (entity != null && entity.getContentLength() != 0L && !ver.lessEquals(HttpVersion.HTTP_1_0) && (active = request.getParams().getBooleanParameter("http.protocol.expect-continue", this.activeByDefault))) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

