/*
 * Decompiled with CFR 0.152.
 */
package jaeger.org.apache.http.protocol;

import jaeger.org.apache.http.HttpConnection;
import jaeger.org.apache.http.HttpException;
import jaeger.org.apache.http.HttpHost;
import jaeger.org.apache.http.HttpInetConnection;
import jaeger.org.apache.http.HttpRequest;
import jaeger.org.apache.http.HttpRequestInterceptor;
import jaeger.org.apache.http.HttpVersion;
import jaeger.org.apache.http.ProtocolException;
import jaeger.org.apache.http.ProtocolVersion;
import jaeger.org.apache.http.annotation.Immutable;
import jaeger.org.apache.http.protocol.HttpContext;
import jaeger.org.apache.http.protocol.HttpCoreContext;
import jaeger.org.apache.http.util.Args;
import java.io.IOException;
import java.net.InetAddress;

@Immutable
public class RequestTargetHost
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        HttpCoreContext corecontext = HttpCoreContext.adapt(context);
        ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT") && ver.lessEquals(HttpVersion.HTTP_1_0)) {
            return;
        }
        if (!request.containsHeader("Host")) {
            HttpHost targethost = corecontext.getTargetHost();
            if (targethost == null) {
                HttpConnection conn = corecontext.getConnection();
                if (conn instanceof HttpInetConnection) {
                    InetAddress address = ((HttpInetConnection)conn).getRemoteAddress();
                    int port = ((HttpInetConnection)conn).getRemotePort();
                    if (address != null) {
                        targethost = new HttpHost(address.getHostName(), port);
                    }
                }
                if (targethost == null) {
                    if (ver.lessEquals(HttpVersion.HTTP_1_0)) {
                        return;
                    }
                    throw new ProtocolException("Target host missing");
                }
            }
            request.addHeader("Host", targethost.toHostString());
        }
    }
}

