'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.CapabilityStore = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /**
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Created by cmeyers on 8/31/16.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */


var _bluebird = require('bluebird');

var _bluebird2 = _interopRequireDefault(_bluebird);

var _storage = require('../storage');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

// Create a dedicated storage namespace that we use to store classes
// info in the browser, eliminating client REST call overhead for classes
// info. This storage namespace will be auto-cleared if the jenkins version
// changes, or if the active plugins change.
var classesInfoNS = _storage.installInfo.subspace('classesInfo');

/**
 * Retrieves capability metadata for class names.
 * Uses an internal cache to minimize REST API calls.
 */

var CapabilityStore = exports.CapabilityStore = function () {
    function CapabilityStore(capabilityApi) {
        _classCallCheck(this, CapabilityStore);

        this._localStore = {};
        this._capabilityApi = capabilityApi;
    }

    /**
     * Fetch the capabilities for one or more class names.
     * Will used cached values if available.
     *
     * @param classNames
     * @returns {Promise} with fulfilled {object} keyed by className, with an array of string capability names.
     */


    _createClass(CapabilityStore, [{
        key: 'resolveCapabilities',
        value: function resolveCapabilities() {
            var result = {};
            var classesToFetch = [];

            // determine which class names are already in the cache and which aren't

            for (var _len = arguments.length, classNames = Array(_len), _key = 0; _key < _len; _key++) {
                classNames[_key] = arguments[_key];
            }

            var _iteratorNormalCompletion = true;
            var _didIteratorError = false;
            var _iteratorError = undefined;

            try {
                for (var _iterator = classNames[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
                    var className = _step.value;

                    var classInfo = this._getStoredClassInfo(className);
                    if (classInfo) {
                        result[className] = classInfo;
                    } else {
                        classesToFetch.push(className);
                    }
                }

                // if nothing to fetch, just return an immediately fulfilled Promise
            } catch (err) {
                _didIteratorError = true;
                _iteratorError = err;
            } finally {
                try {
                    if (!_iteratorNormalCompletion && _iterator.return) {
                        _iterator.return();
                    }
                } finally {
                    if (_didIteratorError) {
                        throw _iteratorError;
                    }
                }
            }

            if (classesToFetch.length === 0) {
                return new _bluebird2.default(function (resolve) {
                    return resolve(result);
                });
            }

            // fetch the capabilities and then merge that with the values already in the cache
            return this._fetchCapabilities(classesToFetch).then(function (fetchedCapabilities) {
                return Object.assign(result, fetchedCapabilities);
            });
        }

        /**
         * Fetch the capabilities for one or more class names.
         *
         * @param classNames
         * @returns {Promise} with fulfilled {object} keyed by className, with an array of string capability names.
         * @private
         */

    }, {
        key: '_fetchCapabilities',
        value: function _fetchCapabilities(classNames) {
            var _this = this;

            return this._capabilityApi.fetchCapabilities(classNames).then(function (data) {
                return _this._storeCapabilities(data.map);
            });
        }

        /**
         * Store the values in the cache and return it.
         *
         * @param map
         * @returns {object} keyed by className, with an array of string capability names.
         * @private
         */

    }, {
        key: '_storeCapabilities',
        value: function _storeCapabilities(map) {
            var _this2 = this;

            var storedCapabilities = {};

            Object.keys(map).forEach(function (className) {
                var capabilities = map[className];
                _this2._localStore[className] = storedCapabilities[className] = capabilities.classes.slice();
                // Also store in the browser so we don't have to look
                // up this info again (unless the storage namespace is
                // cleared due to jenkins or plugin changes).
                classesInfoNS.set(className, _this2._localStore[className]);
            });

            return storedCapabilities;
        }
    }, {
        key: '_getStoredClassInfo',
        value: function _getStoredClassInfo(className) {
            if (!this._localStore[className]) {
                // If we don't have a copy of the class info in the localStore,
                // check the browser storage and copy it into the localStore.
                // We still want to use the localStore because it holds deserialized
                // copies of the class info, which means that a localStore lookup
                // would be lower overhead and probably faster.
                this._localStore[className] = classesInfoNS.get(className);
            }
            return this._localStore[className];
        }
    }]);

    return CapabilityStore;
}();
//# sourceMappingURL=CapabilityStore.js.map
