'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * Created by cmeyers on 9/9/16.
 */

/**
 * Determines whether the supplied object has at least one of the supplied capabilities.
 *
 * As capabilities are typically name-spaced, this method will match on long or short names, e.g.
 * given: _capabilities = ['a.b.Capability1']
 * passing either 'a.b.Capability1' or 'Capability1' will match
 *
 * @param {object} subject
 * @param {...string} capabilityNames
 * @returns {boolean}
 */
var capable = exports.capable = function capable(subject) {
    for (var _len = arguments.length, capabilityNames = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        capabilityNames[_key - 1] = arguments[_key];
    }

    if (subject && subject._capabilities) {
        var _ref;

        // in case an array was passed in, flatten it out
        var flattenedCapabilities = (_ref = []).concat.apply(_ref, capabilityNames);

        // find the intersection of subject's caps with the passed-in caps
        var longNameMatches = flattenedCapabilities.filter(function (longName) {
            return subject._capabilities.indexOf(longName) !== -1;
        });
        if (longNameMatches.length > 0) {
            return true;
        }

        // build short form of subject's caps, then find intersection
        var shortNames = subject._capabilities.map(function (longName) {
            return longName.split('.').slice(-1).join('');
        });

        var shortNameMatches = flattenedCapabilities.filter(function (longName) {
            return shortNames.indexOf(longName) !== -1;
        });
        if (shortNameMatches.length > 0) {
            return true;
        }
    }

    return false;
};

/**
 * Provides some convenience methods for host object of _class/_capabilities
 */

var Capable = exports.Capable = function () {
    function Capable() {
        _classCallCheck(this, Capable);
    }

    _createClass(Capable, [{
        key: 'can',

        /**
         * Determines whether the host object has the supplied capability.
         * As capabilities are typically name-spaced, this method will match on long or short names, e.g.
         * if _capabilities = ['a.b.Capability1']
         * passing either 'a.b.Capability1' or 'Capability1' will match
         *
         * @param {string} capabilityName
         * @returns {boolean}
         */
        value: function can(capabilityName) {
            return capable(this, capabilityName);
        }
    }]);

    return Capable;
}();

exports.default = new Capable();
//# sourceMappingURL=Capable.js.map
