'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.ContentPageHeader = exports.SiteHeader = undefined;
exports._wrap = _wrap;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _designLanguage = require('@jenkins-cd/design-language');

var _jsExtensions = require('@jenkins-cd/js-extensions');

var _jsExtensions2 = _interopRequireDefault(_jsExtensions);

var _BlueLogo = require('./BlueLogo');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

// Wrap an array of elements in a parent element without requiring a bunch "key" props
// FIXME: This should be strengthened a little, and promoted to JDL with some tests
function _wrap(children) {
    var elementOrComponent = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'div';
    var props = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};

    if (!children) {
        return null;
    }

    var childArray = Array.isArray(children) ? children : [children];
    return _react2.default.createElement.apply(_react2.default, [elementOrComponent, props].concat(_toConsumableArray(childArray)));
}

var SiteHeader = exports.SiteHeader = function SiteHeader(props) {
    var topNavLinks = _wrap(props.topNavLinks, 'nav');
    var userComponents = _wrap(props.userComponents, 'div', { className: 'ContentPageHeader-user' });

    return _react2.default.createElement(
        _designLanguage.BasicHeader,
        { className: 'ContentPageHeader' },
        _react2.default.createElement(
            _designLanguage.TopNav,
            null,
            _react2.default.createElement(
                _jsExtensions2.default.Renderer,
                { extensionPoint: 'jenkins.header.logo' },
                _react2.default.createElement(_BlueLogo.BlueLogo, null)
            ),
            _react2.default.createElement('div', { className: 'u-flex-grow' }),
            topNavLinks,
            userComponents
        )
    );
};

SiteHeader.propTypes = {
    topNavLinks: _react.PropTypes.node,
    userComponents: _react.PropTypes.node,
    children: _react.PropTypes.node,
    homeURL: _react.PropTypes.string
};

var ContentPageHeader = exports.ContentPageHeader = function ContentPageHeader(props) {
    var pageTabLinks = _wrap(props.pageTabLinks, _designLanguage.PageTabs, { base: props.pageTabBase });

    return _react2.default.createElement(
        _designLanguage.BasicHeader,
        { className: 'ContentPageHeader' },
        _react2.default.createElement(
            _designLanguage.HeaderDetails,
            null,
            _react2.default.createElement(
                'div',
                { className: 'ContentPageHeader-main u-flex-grow' },
                props.children
            ),
            pageTabLinks
        )
    );
};

ContentPageHeader.propTypes = {
    pageTabLinks: _react.PropTypes.node,
    children: _react.PropTypes.node,
    pageTabBase: _react.PropTypes.string
};
//# sourceMappingURL=ContentPageHeader.js.map
