'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.DisablePipelineButton = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _designLanguage = require('@jenkins-cd/design-language');

var _ = require('../');

var _security = require('../security');

var _utils = require('../utils');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var permit = _security.Security.permit;

/**
 * Disable a pipeline
 */

var DisablePipelineButton = exports.DisablePipelineButton = function (_Component) {
    _inherits(DisablePipelineButton, _Component);

    function DisablePipelineButton(props) {
        _classCallCheck(this, DisablePipelineButton);

        var _this = _possibleConstructorReturn(this, (DisablePipelineButton.__proto__ || Object.getPrototypeOf(DisablePipelineButton)).call(this, props));

        _this.state = {
            disabled: _this.props.pipeline.disabled,
            submittingChange: false
        };
        return _this;
    }

    _createClass(DisablePipelineButton, [{
        key: '_updateState',
        value: function _updateState(newDisabledState) {
            this.setState({
                disabled: newDisabledState
            });
        }
    }, {
        key: '_onDisableClick',
        value: function _onDisableClick() {
            var _this2 = this;

            _.DisableJobApi.disable(this.props.pipeline).then(function () {
                _this2._updateState(true);
                _this2.props.onChangeDisableState(true);
                _this2.setState({ submittingChange: false });
            });
        }
    }, {
        key: '_onEnableClick',
        value: function _onEnableClick() {
            var _this3 = this;

            _.DisableJobApi.enable(this.props.pipeline).then(function () {
                _this3._updateState(false);
                _this3.props.onChangeDisableState(false);
                _this3.setState({ submittingChange: false });
            });
        }
    }, {
        key: 'render',
        value: function render() {
            var _this4 = this;

            var _props = this.props,
                t = _props.t,
                pipeline = _props.pipeline,
                innerButtonClasses = _props.innerButtonClasses;

            //if the user doesn't have config permission, don't show the button

            if (!permit(pipeline).configure()) {
                return false;
            }

            var buttonDisabled = this.state.submittingChange ? true : false;

            var buttonLabel = void 0;
            var buttonIcon = void 0;

            if (this.state.disabled) {
                buttonLabel = t('pipelinedetail.activity.header.enable.job', { defaultValue: 'Enable Job' });
                buttonIcon = 'ActionCheckCircleOutline';
            } else {
                buttonLabel = t('pipelinedetail.activity.header.disable.job', { defaultValue: 'Disable Job' });
                buttonIcon = 'AvNotInterested';
            }

            var onClick = function onClick() {
                if (!_this4.state.submittingChange) {
                    _this4.setState({ submittingChange: true });
                    _this4.state.disabled ? _this4._onEnableClick() : _this4._onDisableClick();
                }
            };

            return _react2.default.createElement(
                'div',
                { className: 'disable-job-button', onClick: function onClick(event) {
                        return (0, _utils.stopProp)(event);
                    } },
                _react2.default.createElement(
                    'a',
                    { className: '' + innerButtonClasses, title: buttonLabel, onClick: onClick, disabled: buttonDisabled },
                    _react2.default.createElement(_designLanguage.Icon, { size: 24, icon: buttonIcon, style: { marginRight: '5px' } }),
                    _react2.default.createElement(
                        'span',
                        { className: 'button-label' },
                        buttonLabel
                    )
                )
            );
        }
    }]);

    return DisablePipelineButton;
}(_react.Component);

DisablePipelineButton.propTypes = {
    t: _react.PropTypes.func,
    pipeline: _react.PropTypes.object,
    onClick: _react.PropTypes.func,
    onChangeDisableState: _react.PropTypes.func,
    buttonText: _react.PropTypes.string,
    innerButtonClasses: _react.PropTypes.string
};

DisablePipelineButton.defaultProps = {
    innerButtonClasses: 'btn inverse'
};
//# sourceMappingURL=DisablePipelineButton.js.map
