'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.RunButton = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _designLanguage = require('@jenkins-cd/design-language');

var _ = require('../');

var _ToastUtils = require('../ToastUtils');

var _security = require('../security');

var _utils = require('../utils');

var _i18n = require('../i18n/i18n');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /**
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * Created by cmeyers on 8/26/16.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                */


var translate = (0, _i18n.i18nTranslator)('blueocean-web');

var permit = _security.Security.permit;

/**
 * Run Buttons allows a pipeline or branch to be run and also be stopped thereafter.
 */

var RunButton = exports.RunButton = function (_Component) {
    _inherits(RunButton, _Component);

    function RunButton(props) {
        _classCallCheck(this, RunButton);

        var _this = _possibleConstructorReturn(this, (RunButton.__proto__ || Object.getPrototypeOf(RunButton)).call(this, props));

        _this.state = {
            running: false,
            stopping: false
        };
        return _this;
    }

    _createClass(RunButton, [{
        key: 'componentWillReceiveProps',
        value: function componentWillReceiveProps(nextProps) {
            this._updateState(nextProps);
        }
    }, {
        key: '_updateState',
        value: function _updateState(nextProps) {
            var oldStatus = this.props.latestRun && this.props.latestRun.state || '';
            var newStatus = nextProps.latestRun && nextProps.latestRun.state || '';

            // if the state of the run changed, then assume it's no longer trying to stop
            if (oldStatus !== newStatus) {
                this.setState({
                    stopping: false
                });
            }
        }
    }, {
        key: '_onRunClick',
        value: function _onRunClick() {
            var _this2 = this;

            _.RunApi.startRun(this.props.runnable).then(function (run) {
                return _ToastUtils.ToastUtils.createRunStartedToast(_this2.props.runnable, run, _this2.props.onNavigation);
            });
        }
    }, {
        key: '_onStopClick',
        value: function _onStopClick() {
            if (this.state.stopping) {
                return;
            }

            this.setState({
                stopping: true
            });

            _.RunApi.stopRun(this.props.latestRun);

            var name = decodeURIComponent(this.props.runnable.name);
            var runId = this.props.latestRun.id;
            var text = translate('toast.run.stopping', {
                0: name,
                1: runId,
                defaultValue: 'Stopping "{0}" #{1}'
            });

            _.ToastService.newToast({ text: text });
        }
    }, {
        key: 'render',
        value: function render() {
            var _this3 = this;

            var buttonType = this.props.buttonType;
            var outerClass = this.props.className ? this.props.className : '';
            var outerClassNames = outerClass.split(' ');
            var innerButtonClass = outerClassNames.indexOf('icon-button') === -1 ? this.props.innerButtonClasses : '';
            var stopClass = this.state.stopping ? 'stopping' : '';

            var status = this.props.latestRun ? this.props.latestRun.state : '';
            var isPaused = status.toLowerCase() === 'paused';
            var runningStatus = status && (isPaused || status.toLowerCase() === 'running' || status.toLowerCase() === 'queued');

            var showRunButton = buttonType === 'run-only' || buttonType === 'toggle' && !runningStatus;
            var showStopButton = runningStatus && (buttonType === 'toggle' || buttonType === 'stop-only');

            showRunButton = showRunButton && permit(this.props.runnable).start();
            showStopButton = showStopButton && permit(this.props.runnable).stop();

            var runLabel = this.props.runText || translate('toast.run', {
                defaultValue: 'Run'
            });
            var stopLabel = this.state.stopping ? translate('toast.stopping', {
                defaultValue: 'Stopping ...'
            }) : translate('toast.stop', {
                defaultValue: 'Stop'
            });

            if (isPaused && !this.state.stopping) {
                stopLabel = translate('toast.abort', { defaultValue: 'Abort' });
            }

            if (!showRunButton && !showStopButton) {
                return null;
            }

            var _props$onClick = this.props.onClick,
                onClick = _props$onClick === undefined ? function () {
                return _this3._onRunClick();
            } : _props$onClick;


            return _react2.default.createElement(
                'div',
                { className: 'run-button-component ' + outerClass, onClick: function onClick(event) {
                        return (0, _utils.stopProp)(event);
                    } },
                showRunButton && _react2.default.createElement(
                    'a',
                    { className: 'run-button ' + innerButtonClass, title: runLabel, onClick: onClick },
                    _react2.default.createElement(_designLanguage.Icon, { size: 24, icon: 'AvPlayCircleOutline', style: { marginRight: '5px' } }),
                    _react2.default.createElement(
                        'span',
                        { className: 'button-label' },
                        runLabel
                    )
                ),
                showStopButton && _react2.default.createElement(
                    'a',
                    { className: 'stop-button ' + innerButtonClass + ' ' + stopClass, title: stopLabel, onClick: function onClick() {
                            return _this3._onStopClick();
                        } },
                    _react2.default.createElement(
                        'svg',
                        { className: 'svg-icon', width: '20', height: '20', viewBox: '0 0 20 20', xmlns: 'http://www.w3.org/2000/svg' },
                        _react2.default.createElement(
                            'g',
                            { fill: 'none', 'fill-rule': 'evenodd' },
                            _react2.default.createElement('path', { d: 'M-2-2h24v24H-2z' }),
                            _react2.default.createElement('path', {
                                className: 'svg-icon-inner action-button-fill',
                                d: 'M10 0C4.48 0 0 4.48 0 10s4.48 10 10 10 10-4.48 10-10S15.52 0 10 0zM7 7h6v6H7V7zm3 11c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8z'
                            })
                        )
                    ),
                    _react2.default.createElement(
                        'span',
                        { className: 'button-label' },
                        stopLabel
                    )
                )
            );
        }
    }]);

    return RunButton;
}(_react.Component);

RunButton.propTypes = {
    buttonType: _react.PropTypes.oneOf(['toggle', 'stop-only', 'run-only']),
    className: _react.PropTypes.string,
    runnable: _react.PropTypes.object,
    latestRun: _react.PropTypes.object,
    onNavigation: _react.PropTypes.func,
    onClick: _react.PropTypes.func,
    runText: _react.PropTypes.string,
    innerButtonClasses: _react.PropTypes.string
};

RunButton.defaultProps = {
    buttonType: 'toggle',
    innerButtonClasses: 'btn inverse'
};
//# sourceMappingURL=RunButton.js.map
