/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest.impl.pipeline.scm;

import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Item;
import java.util.List;
import jenkins.branch.MultiBranchProject;
import jenkins.branch.OrganizationFolder;
import jenkins.scm.api.SCMNavigator;
import jenkins.scm.api.SCMSource;

public abstract class ScmContentProviderParams {
    private final String apiUrl;
    private final String owner;
    private final String repo;
    private final StandardUsernamePasswordCredentials credentials;

    public ScmContentProviderParams(Item item) {
        List sources;
        String apiUrl = null;
        String owner = null;
        String repo = null;
        if (item instanceof OrganizationFolder) {
            List navigators = ((OrganizationFolder)item).getSCMNavigators();
            if (!navigators.isEmpty()) {
                SCMNavigator navigator = (SCMNavigator)navigators.get(0);
                apiUrl = this.apiUrl(navigator);
                owner = this.owner(navigator);
            }
        } else if (item instanceof MultiBranchProject && !(sources = ((MultiBranchProject)item).getSCMSources()).isEmpty()) {
            SCMSource source = (SCMSource)sources.get(0);
            apiUrl = this.apiUrl(source);
            owner = this.owner(source);
            repo = this.repo(source);
        }
        this.apiUrl = apiUrl == null ? "https://api.github.com" : apiUrl;
        this.owner = owner;
        this.repo = repo;
        this.credentials = this.getCredentialForUser(item, this.apiUrl);
    }

    public String getApiUrl() {
        return this.apiUrl;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getRepo() {
        return this.repo;
    }

    public StandardUsernamePasswordCredentials getCredentials() {
        return this.credentials;
    }

    @CheckForNull
    protected abstract String owner(@NonNull SCMSource var1);

    @CheckForNull
    protected abstract String owner(@NonNull SCMNavigator var1);

    @CheckForNull
    protected abstract String repo(@NonNull SCMSource var1);

    @CheckForNull
    protected abstract String apiUrl(@NonNull SCMSource var1);

    @CheckForNull
    protected abstract String apiUrl(@NonNull SCMNavigator var1);

    @NonNull
    protected abstract StandardUsernamePasswordCredentials getCredentialForUser(@NonNull Item var1, @NonNull String var2);
}

