'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.EmptyStateView = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _EmptyStateIcon = require('./EmptyStateIcon');

var _Icon = require('./Icon');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * Displays an "empty state" dialog with arbitrary child content and an optional icon.
 *
 * Content in the following form will recent nice default styles:
 *
 * <h1>Title<h1>
 * <p>A longer message...</p>
 * <button>Take Action!</button> *
 *
 * Properties:
 * iconName="branch|goat|shoes|<any-Icon-type>"
 * tightSpacing={true|false}
 */
var EmptyStateView = exports.EmptyStateView = function (_Component) {
    _inherits(EmptyStateView, _Component);

    function EmptyStateView() {
        _classCallCheck(this, EmptyStateView);

        return _possibleConstructorReturn(this, (EmptyStateView.__proto__ || Object.getPrototypeOf(EmptyStateView)).apply(this, arguments));
    }

    _createClass(EmptyStateView, [{
        key: 'render',
        value: function render() {
            var layoutClasses = 'empty-state-container';

            if (this.props.tightSpacing) {
                layoutClasses = layoutClasses + ' tight-spacing';
            }

            var icon = null;
            if (this.props.iconName) {
                if (['branch', 'goat', 'shoes'].indexOf(this.props.iconName) >= 0) {
                    icon = _react2.default.createElement(_EmptyStateIcon.EmptyStateIcon, { name: this.props.iconName });
                } else {
                    icon = _react2.default.createElement(
                        'div',
                        { className: 'empty-state-icon', style: { paddingLeft: 0 } },
                        _react2.default.createElement(_Icon.Icon, { size: 150, icon: this.props.iconName, style: { fill: '#fff' } })
                    );
                }
            }

            return _react2.default.createElement(
                'div',
                { className: 'empty-state' },
                _react2.default.createElement(
                    'div',
                    { className: layoutClasses },
                    icon,
                    _react2.default.createElement(
                        'div',
                        { className: 'empty-state-content' },
                        this.props.children
                    )
                )
            );
        }
    }]);

    return EmptyStateView;
}(_react.Component);

EmptyStateView.propTypes = {
    children: _react.PropTypes.node,
    iconName: _react.PropTypes.string,
    tightSpacing: _react.PropTypes.bool
};
//# sourceMappingURL=EmptyStateView.js.map
