'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _storybook = require('@kadira/storybook');

var _components = require('../components');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

(0, _storybook.storiesOf)('FloatingElement', module).add('Above', function () {
  return _react2.default.createElement(ExampleBasic, { positionFunction: _components.PositionFunctions.above });
}).add('Below', function () {
  return _react2.default.createElement(ExampleBasic, { positionFunction: _components.PositionFunctions.below });
}).add('Left', function () {
  return _react2.default.createElement(ExampleBasic, { positionFunction: _components.PositionFunctions.left });
}).add('Right', function () {
  return _react2.default.createElement(ExampleBasic, { positionFunction: _components.PositionFunctions.right });
});

var triggerStyle = {
  display: 'block',
  position: 'fixed',
  minWidth: '0px',
  width: '100px',
  height: '100px',
  padding: '0px'
};

var triggerStyleCenter = _extends({}, triggerStyle, {
  left: '50%',
  top: '50%',
  marginLeft: '-50px',
  marginTop: '-50px'
});

var triggerStyleNW = _extends({}, triggerStyle, {
  left: '1em',
  top: '1em'
});

var triggerStyleNE = _extends({}, triggerStyle, {
  right: '1em',
  top: '1em'
});

var triggerStyleSW = _extends({}, triggerStyle, {
  left: '1em',
  bottom: '1em'
});

var triggerStyleSE = _extends({}, triggerStyle, {
  right: '1em',
  bottom: '1em'
});

var popoverStyle = {
  maxWidth: '22em'
};

var ExampleBasic = function (_Component) {
  _inherits(ExampleBasic, _Component);

  function ExampleBasic(props) {
    _classCallCheck(this, ExampleBasic);

    var _this = _possibleConstructorReturn(this, (ExampleBasic.__proto__ || Object.getPrototypeOf(ExampleBasic)).call(this, props));

    _this.triggerClicked = function (e) {
      e.target.blur();
      _this.setState({ targetElement: e.target });
    };

    _this.popoverDismissed = function () {
      _this.setState({ targetElement: null });
    };

    _this.state = {
      targetElement: null
    };
    return _this;
  }

  _createClass(ExampleBasic, [{
    key: 'render',
    value: function render() {
      var targetElement = this.state.targetElement;
      var positionFunction = this.props.positionFunction;


      return _react2.default.createElement(
        'div',
        null,
        _react2.default.createElement(
          'button',
          { style: triggerStyleNW, onClick: this.triggerClicked },
          'Trigger'
        ),
        _react2.default.createElement(
          'button',
          { style: triggerStyleNE, onClick: this.triggerClicked },
          'Trigger'
        ),
        _react2.default.createElement(
          'button',
          { style: triggerStyleCenter, onClick: this.triggerClicked },
          'Trigger'
        ),
        _react2.default.createElement(
          'button',
          { style: triggerStyleSW, onClick: this.triggerClicked },
          'Trigger'
        ),
        _react2.default.createElement(
          'button',
          { style: triggerStyleSE, onClick: this.triggerClicked },
          'Trigger'
        ),
        targetElement && _react2.default.createElement(
          _components.FloatingElement,
          { positionFunction: positionFunction,
            targetElement: targetElement,
            onDismiss: this.popoverDismissed,
            style: popoverStyle },
          _react2.default.createElement(
            'div',
            null,
            _react2.default.createElement(
              'h3',
              null,
              'This is my Popover'
            ),
            _react2.default.createElement(
              'p',
              null,
              'There are many like it, but this one is mine. The quick brown fox jumps over the lazy dog.'
            )
          )
        )
      );
    }
  }]);

  return ExampleBasic;
}(_react.Component);

ExampleBasic.propTypes = {
  positionFunction: _react.PropTypes.func
};
//# sourceMappingURL=FloatingElementStories.js.map
