'use strict';

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _storybook = require('@kadira/storybook');

var _FileSize = require('../components/FileSize');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

(0, _storybook.storiesOf)('FileSize', module).add('0 bytes', scenario0).add('5 bytes', scenario1).add('1 kilobyte', scenario2).add('5.5 kilobyte', scenario3).add('102.5 megs', scenario4).add('5500 string', scenario5).add('bogus', scenario6).add('large', scenario7).add('negative', scenario8);

function scenario0() {
    return _react2.default.createElement(_FileSize.FileSize, { bytes: 0 });
}

function scenario1() {
    return _react2.default.createElement(_FileSize.FileSize, { bytes: 5 });
}

function scenario2() {
    return _react2.default.createElement(_FileSize.FileSize, { bytes: 1024 });
}

function scenario3() {
    return _react2.default.createElement(_FileSize.FileSize, { bytes: 1024 * 5.5 });
}

function scenario4() {
    return _react2.default.createElement(_FileSize.FileSize, { bytes: 1024 * 1024 * 102.5 });
}

function scenario5() {
    return _react2.default.createElement(_FileSize.FileSize, { bytes: '5500' });
}

function scenario6() {
    return _react2.default.createElement(_FileSize.FileSize, { bytes: 'bogus' });
}

function scenario7() {
    return _react2.default.createElement(_FileSize.FileSize, { bytes: 1024 * Math.pow(10, 20) });
}

function scenario8() {
    return _react2.default.createElement(_FileSize.FileSize, { bytes: -1024 * 1024 * 5.5 });
}
//# sourceMappingURL=filesize.js.map
