/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.casc.misc.junit.jupiter;

import io.jenkins.plugins.casc.ConfigurationAsCode;
import io.jenkins.plugins.casc.ConfiguratorException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collections;
import java.util.logging.Level;
import org.apache.commons.io.IOUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.htmlunit.HttpMethod;
import org.htmlunit.WebRequest;
import org.htmlunit.WebResponse;
import org.htmlunit.util.NameValuePair;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.LogRecorder;
import org.jvnet.hudson.test.junit.jupiter.WithJenkins;

@WithJenkins
public abstract class AbstractRoundTripTest {
    @TempDir
    public Path tempFolder;

    protected abstract void assertConfiguredAsExpected(JenkinsRule var1, String var2);

    protected String configResource() {
        return "configuration-as-code.yaml";
    }

    protected abstract String stringInLogExpected();

    @Test
    public void roundTripTest(JenkinsRule r) throws Throwable {
        String resourcePath = this.configResource();
        String resourceContent = this.getResourceContent(resourcePath);
        Assertions.assertNotNull((Object)resourcePath);
        Assertions.assertNotNull((Object)resourceContent);
        this.configureWithResource(resourcePath);
        this.assertConfiguredAsExpected(r, resourceContent);
        String jenkinsConf = this.getResourceContent(resourcePath);
        this.assertConfigViaWebUI(r, jenkinsConf);
        this.applyConfigViaWebUI(r, jenkinsConf);
        this.assertConfiguredAsExpected(r, resourceContent);
        this.putConfigInHome(r, jenkinsConf);
        try (LogRecorder recorder = new LogRecorder().record("io.jenkins.plugins.casc", Level.FINER).capture(2048);){
            r.restart();
            this.assertLogAsExpected(recorder, this.stringInLogExpected());
        }
        this.assertConfiguredAsExpected(r, resourceContent);
    }

    private void configureWithResource(String config) throws ConfiguratorException {
        ConfigurationAsCode.get().configure(new String[]{this.getClass().getResource(config).toExternalForm()});
    }

    private String getResourceContent(String resourcePath) throws IOException {
        return IOUtils.toString((InputStream)this.getClass().getResourceAsStream(resourcePath), (Charset)StandardCharsets.UTF_8);
    }

    private void writeToFile(String text, String path) throws FileNotFoundException {
        File file = new File(path);
        try (PrintWriter out = new PrintWriter(file);){
            out.print(text);
        }
    }

    private void putConfigInHome(JenkinsRule r, String config) throws Exception {
        File configFile = new File(r.getWebAppRoot(), "jenkins.yaml");
        this.writeToFile(config, configFile.getAbsolutePath());
        Assertions.assertTrue((boolean)configFile.exists(), (String)"jenkins.yaml should be created");
    }

    private void assertConfigViaWebUI(JenkinsRule r, String jenkinsConfig) throws Exception {
        File f = File.createTempFile("junit", null, this.tempFolder.toFile());
        this.writeToFile(jenkinsConfig, f.getAbsolutePath());
        JenkinsRule.WebClient client = r.createWebClient();
        WebRequest request = new WebRequest(client.createCrumbedUrl("configuration-as-code/checkNewSource"), HttpMethod.POST);
        NameValuePair param = new NameValuePair("newSource", f.toURI().toURL().toExternalForm());
        request.setRequestParameters(Collections.singletonList(param));
        WebResponse response = client.loadWebResponse(request);
        Assertions.assertEquals((int)200, (int)response.getStatusCode(), (String)("Failed to POST to " + request.getUrl().toString()));
        String res = response.getContentAsString();
        MatcherAssert.assertThat((Object)res, (Matcher)Matchers.containsString((String)"The configuration can be applied"));
    }

    private void applyConfigViaWebUI(JenkinsRule r, String jenkinsConfig) throws Exception {
        File f = File.createTempFile("junit", null, this.tempFolder.toFile());
        this.writeToFile(jenkinsConfig, f.getAbsolutePath());
        JenkinsRule.WebClient client = r.createWebClient();
        WebRequest request = new WebRequest(client.createCrumbedUrl("configuration-as-code/replace"), HttpMethod.POST);
        NameValuePair param = new NameValuePair("_.newSource", f.toURI().toURL().toExternalForm());
        request.setRequestParameters(Collections.singletonList(param));
        request.setRequestParameters(Collections.singletonList(param));
        WebResponse response = client.loadWebResponse(request);
        Assertions.assertEquals((int)200, (int)response.getStatusCode(), (String)("Failed to POST to " + request.getUrl().toString()));
        String res = response.getContentAsString();
        MatcherAssert.assertThat((Object)res, (Matcher)Matchers.containsString((String)f.toURI().toURL().toExternalForm()));
    }

    private void assertLogAsExpected(LogRecorder recorder, String uniqueText) {
        Assertions.assertTrue((boolean)recorder.getMessages().stream().anyMatch(m -> m.contains(uniqueText)), (String)("The log should have '" + uniqueText + "'"));
    }
}

