/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.customizable_header.headers;

import hudson.model.TopLevelItem;
import hudson.model.User;
import io.jenkins.plugins.customizable_header.AbstractLink;
import io.jenkins.plugins.customizable_header.CustomHeaderConfiguration;
import io.jenkins.plugins.customizable_header.SystemMessage;
import io.jenkins.plugins.customizable_header.UserHeader;
import io.jenkins.plugins.customizable_header.logo.Logo;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jenkins.model.Jenkins;
import jenkins.views.PartialHeader;
import org.kohsuke.stapler.Ancestor;
import org.kohsuke.stapler.Stapler;

public abstract class AbstractCustomHeader
extends PartialHeader {
    public int getSupportedHeaderVersion() {
        return 2;
    }

    public Logo getLogo() {
        return CustomHeaderConfiguration.get().getActiveLogo();
    }

    public String getLogoText() {
        return CustomHeaderConfiguration.get().getLogoText();
    }

    public String getTitle() {
        StringWriter writer = new StringWriter();
        try {
            Jenkins.get().getMarkupFormatter().translate(CustomHeaderConfiguration.get().getTitle(), (Writer)writer);
            return writer.toString();
        }
        catch (IOException e) {
            return "";
        }
    }

    public boolean hasLinks() {
        return CustomHeaderConfiguration.get().hasLinks();
    }

    public List<AbstractLink> getLinks() {
        return CustomHeaderConfiguration.get().getLinks();
    }

    public String getItemContextFullName() {
        ArrayList ancestors = new ArrayList(Stapler.getCurrentRequest2().getAncestors());
        Collections.reverse(ancestors);
        for (Ancestor ancestor : ancestors) {
            Object obj = ancestor.getObject();
            if (!(obj instanceof TopLevelItem)) continue;
            TopLevelItem item = (TopLevelItem)obj;
            return item.getFullName();
        }
        return null;
    }

    public List<SystemMessage> getSystemMessages() {
        return CustomHeaderConfiguration.get().getSystemMessages();
    }

    public boolean isClassicSearch() {
        UserHeader userHeader;
        User user = User.current();
        if (user != null && (userHeader = (UserHeader)user.getProperty(UserHeader.class)) != null) {
            return userHeader.isClassicSearch();
        }
        return false;
    }
}

