/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.echarts;

import edu.hm.hafner.echarts.JacksonFacade;

public class ChartModelConfiguration {
    static final int DEFAULT_BUILD_COUNT = 50;
    static final int DEFAULT_DAY_COUNT = 0;
    static final AxisType DEFAULT_DOMAIN_AXIS_TYPE = AxisType.BUILD;
    private static final String NUMBER_OF_BUILDS_PROPERTY = "numberOfBuilds";
    private static final String NUMBER_OF_DAYS_PROPERTY = "numberOfDays";
    private static final String BUILD_AS_DOMAIN_PROPERTY = "buildAsDomain";
    private static final JacksonFacade JACKSON = new JacksonFacade();
    private final AxisType axisType;
    private final int buildCount;
    private final int dayCount;

    public ChartModelConfiguration() {
        this(DEFAULT_DOMAIN_AXIS_TYPE);
    }

    public ChartModelConfiguration(AxisType axisType) {
        this(axisType, 50, 0);
    }

    public ChartModelConfiguration(AxisType axisType, int buildCount, int dayCount) {
        this.axisType = axisType;
        this.buildCount = buildCount < 0 ? 50 : buildCount;
        this.dayCount = dayCount < 0 ? 0 : dayCount;
    }

    public static ChartModelConfiguration fromJson(String json) {
        return new ChartModelConfiguration(JACKSON.getBoolean(json, BUILD_AS_DOMAIN_PROPERTY, true) ? AxisType.BUILD : AxisType.DATE, JACKSON.getInteger(json, NUMBER_OF_BUILDS_PROPERTY, 50), JACKSON.getInteger(json, NUMBER_OF_DAYS_PROPERTY, 0));
    }

    public AxisType getAxisType() {
        return this.axisType;
    }

    public int getBuildCount() {
        return this.buildCount;
    }

    public boolean isBuildCountDefined() {
        return this.buildCount > 1;
    }

    public int getDayCount() {
        return this.dayCount;
    }

    public boolean isDayCountDefined() {
        return this.dayCount > 0;
    }

    public static enum AxisType {
        BUILD,
        DATE;

    }
}

